/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.tile;

import io.github.tofodroid.mods.mimi.common.tile.AConfigurableMidiTile;
import io.github.tofodroid.mods.mimi.util.MidiNbtDataUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class AConfigurableMidiNoteResponsiveTile
extends AConfigurableMidiTile {
    protected Boolean firstTick = true;
    protected Integer enabledChannels;
    protected Integer filterOctMin;
    protected Integer filterOctMax;
    protected Byte filterNote;
    protected Byte filteredInstrument;
    protected Boolean invertFilterNoteOct;

    public static void doTick(Level world, BlockPos pos, BlockState state, AConfigurableMidiNoteResponsiveTile self) {
        self.tick(world, pos, state);
    }

    public AConfigurableMidiNoteResponsiveTile(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        this(type, pos, state, 1);
    }

    protected AConfigurableMidiNoteResponsiveTile(BlockEntityType<?> type, BlockPos pos, BlockState state, Integer inventorySize) {
        super(type, pos, state, inventorySize);
    }

    protected void tick(Level world, BlockPos pos, BlockState state) {
        if (world instanceof ServerLevel) {
            this.execServerTick((ServerLevel)world, pos, state);
            if (this.firstTick.booleanValue()) {
                this.cacheMidiSettings();
                this.firstTick = false;
                this.onFirstTick((ServerLevel)world, pos, state);
            }
        }
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.cacheMidiSettings();
    }

    @Override
    public void setSourceStack(ItemStack stack) {
        super.setSourceStack(stack);
        this.cacheMidiSettings();
    }

    public void m_7651_() {
        super.m_7651_();
        if (!this.m_58904_().m_5776_()) {
            this.firstTick = true;
        }
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        if (!this.m_58904_().m_5776_()) {
            this.firstTick = true;
        }
    }

    public Integer getEnabledChannelsInt() {
        return this.enabledChannels;
    }

    public Byte getFilteredInstrument() {
        return this.filteredInstrument;
    }

    protected void cacheMidiSettings() {
        if (this.getSourceStack() == null) {
            return;
        }
        this.enabledChannels = MidiNbtDataUtils.getEnabledChannelsInt(this.getSourceStack());
        Byte filterOct = MidiNbtDataUtils.getFilterOct(this.getSourceStack());
        this.filterOctMin = filterOct * 12;
        this.filterOctMax = (filterOct + 1) * 12;
        this.filterNote = MidiNbtDataUtils.getFilterNote(this.getSourceStack());
        this.filteredInstrument = MidiNbtDataUtils.getFilterInstrument(this.getSourceStack());
        this.invertFilterNoteOct = MidiNbtDataUtils.getInvertNoteOct(this.getSourceStack());
    }

    protected void execServerTick(ServerLevel world, BlockPos pos, BlockState state) {
    }

    protected void onFirstTick(ServerLevel world, BlockPos pos, BlockState state) {
    }

    public abstract void onNoteOn(@Nullable Byte var1, @Nonnull Byte var2, @Nonnull Byte var3, @Nullable Byte var4, Long var5);

    public abstract void onNoteOff(@Nullable Byte var1, @Nonnull Byte var2, @Nonnull Byte var3, @Nullable Byte var4, Long var5);

    public abstract void onReset(@Nullable Byte var1, @Nullable Byte var2, Long var3);
}

