/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.network;

import io.github.tofodroid.mods.mimi.common.MIMIMod;
import io.github.tofodroid.mods.mimi.common.api.event.MidiEventType;
import io.github.tofodroid.mods.mimi.common.api.event.note.NoteEvent;
import io.github.tofodroid.mods.mimi.common.network.CustomPacketPayload;
import io.github.tofodroid.mods.mimi.common.network.NoteEventPacket;
import io.github.tofodroid.mods.mimi.util.ByteUtils;
import io.github.tofodroid.mods.mimi.util.NetworkUtils;
import io.github.tofodroid.mods.mimi.util.ResourceUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;

public class MultiNoteEventPacket
implements CustomPacketPayload {
    public static final ResourceLocation ID = ResourceUtils.newModLocation(MultiNoteEventPacket.class.getSimpleName().toLowerCase());
    private final Map<Long, ArrayList<NoteEvent>> sourceMap;
    public final TreeMap<Long, List<NoteEventPacket>> resultPackets;

    @Override
    public ResourceLocation id() {
        return ID;
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        MultiNoteEventPacket.encodePacket(this, buf);
    }

    public MultiNoteEventPacket(Map<Long, ArrayList<NoteEvent>> sourceMap) {
        this.sourceMap = new HashMap<Long, ArrayList<NoteEvent>>(sourceMap);
        this.resultPackets = new TreeMap();
        for (Map.Entry<Long, ArrayList<NoteEvent>> sourceEntry : sourceMap.entrySet()) {
            ArrayList<NoteEventPacket> packets = new ArrayList<NoteEventPacket>();
            for (NoteEvent event : sourceEntry.getValue()) {
                packets.add(NoteEventPacket.fromNoteEvent(event));
            }
            this.resultPackets.put(sourceEntry.getKey(), packets);
        }
    }

    public MultiNoteEventPacket(TreeMap<Long, List<NoteEventPacket>> packets) {
        this.resultPackets = packets;
        this.sourceMap = Map.of();
    }

    public static MultiNoteEventPacket decodePacket(FriendlyByteBuf buf) {
        try {
            TreeMap<Long, List<NoteEventPacket>> resultMap = new TreeMap<Long, List<NoteEventPacket>>();
            Integer numTimes = buf.readInt();
            Integer timeIndex = 0;
            while (timeIndex < numTimes) {
                Long noteServerTime = buf.readLong();
                List timePackets = resultMap.computeIfAbsent(noteServerTime, time -> new ArrayList());
                Integer numEvents = buf.readInt();
                Integer eventIndex = 0;
                while (eventIndex < numEvents) {
                    MidiEventType type = MidiEventType.fromByte(buf.readByte());
                    Byte channel = buf.readByte();
                    Byte data1 = ByteUtils.ZERO;
                    Byte data2 = ByteUtils.ZERO;
                    if (type != MidiEventType.RESET) {
                        data1 = buf.readByte();
                    }
                    if (type != MidiEventType.RESET || type != MidiEventType.NOTE_OFF) {
                        data2 = buf.readByte();
                    }
                    UUID playerId = buf.m_130259_();
                    BlockPos pos = buf.m_130135_();
                    Byte instrumentId = buf.readByte();
                    InteractionHand instrumentHand = NetworkUtils.decodeHand(buf.readByte());
                    Integer extData = null;
                    if (buf.readBoolean()) {
                        extData = buf.readInt();
                    }
                    timePackets.add(new NoteEventPacket(type, channel, data1, data2, instrumentId, playerId, pos, noteServerTime, instrumentHand, extData));
                    Integer n = eventIndex;
                    eventIndex = eventIndex + 1;
                }
                Integer n = timeIndex;
                timeIndex = timeIndex + 1;
            }
            return new MultiNoteEventPacket(resultMap);
        }
        catch (IndexOutOfBoundsException e) {
            MIMIMod.LOGGER.error("MultiNoteEventPacket did not contain enough bytes. Exception: " + String.valueOf(e));
            return null;
        }
    }

    public static void encodePacket(MultiNoteEventPacket pkt, FriendlyByteBuf buf) {
        buf.writeInt(pkt.resultPackets.size());
        for (Map.Entry<Long, ArrayList<NoteEvent>> timeEntry : pkt.sourceMap.entrySet()) {
            if (timeEntry.getValue() == null || timeEntry.getValue().isEmpty()) continue;
            buf.writeLong(timeEntry.getKey().longValue());
            buf.writeInt(timeEntry.getValue().size());
            for (NoteEvent noteEvent : timeEntry.getValue()) {
                buf.writeByte((int)noteEvent.type.toByte().byteValue());
                buf.writeByte((int)noteEvent.channel.byteValue());
                if (noteEvent.type != MidiEventType.RESET) {
                    buf.writeByte((int)noteEvent.note.byteValue());
                }
                if (noteEvent.type != MidiEventType.RESET || noteEvent.type != MidiEventType.NOTE_OFF) {
                    buf.writeByte((int)noteEvent.velocity.byteValue());
                }
                buf.m_130077_(noteEvent.senderId);
                buf.m_130064_(noteEvent.pos);
                buf.writeByte((int)noteEvent.instrumentId.byteValue());
                buf.writeByte((int)NetworkUtils.encodeHand(noteEvent.handIn).byteValue());
                buf.writeBoolean(noteEvent.extData != null);
                if (noteEvent.extData == null) continue;
                buf.writeInt(noteEvent.extData.intValue());
            }
        }
    }
}

