/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.network;

import io.github.tofodroid.mods.mimi.common.MIMIMod;
import io.github.tofodroid.mods.mimi.common.api.event.MidiEventType;
import io.github.tofodroid.mods.mimi.common.api.event.broadcast.BroadcastEvent;
import io.github.tofodroid.mods.mimi.common.network.CustomPacketPayload;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class BroadcastEventPacket
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("mimi", BroadcastEventPacket.class.getSimpleName().toLowerCase());
    @Nonnull
    public final MidiEventType type;
    @Nonnull
    public final Byte channel;
    @Nonnull
    public final Byte note;
    @Nonnull
    public final Byte velocity;
    @Nonnull
    public final UUID player;
    @Nonnull
    public final BlockPos pos;
    @Nonnull
    public final Long noteServerTime;

    public static BroadcastEventPacket fromBroadcastEvent(BroadcastEvent event) {
        return new BroadcastEventPacket(event.type, event.channel, event.note, event.velocity, event.senderId, event.pos, event.eventTime);
    }

    protected BroadcastEventPacket(MidiEventType type, Byte channel, Byte note, Byte velocity, UUID player, BlockPos pos, Long noteServerTime) {
        this.type = type;
        this.channel = channel;
        this.note = note;
        this.velocity = velocity;
        this.player = player;
        this.pos = pos;
        this.noteServerTime = noteServerTime;
    }

    @Override
    public ResourceLocation id() {
        return ID;
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        BroadcastEventPacket.encodePacket(this, buf);
    }

    public static BroadcastEventPacket decodePacket(FriendlyByteBuf buf) {
        try {
            MidiEventType type = MidiEventType.fromByte(buf.readByte());
            byte channel = buf.readByte();
            byte note = buf.readByte();
            byte velocity = buf.readByte();
            UUID player = buf.m_130259_();
            BlockPos pos = buf.m_130135_();
            Long noteServerTime = buf.readLong();
            return new BroadcastEventPacket(type, channel, note, velocity, player, pos, noteServerTime);
        }
        catch (IndexOutOfBoundsException e) {
            MIMIMod.LOGGER.error("MidiDeviceBroadcastPacket did not contain enough bytes. Exception: " + String.valueOf(e));
            return null;
        }
    }

    public static void encodePacket(BroadcastEventPacket pkt, FriendlyByteBuf buf) {
        buf.writeByte((int)pkt.type.toByte().byteValue());
        buf.writeByte((int)pkt.channel.byteValue());
        buf.writeByte((int)pkt.note.byteValue());
        buf.writeByte((int)pkt.velocity.byteValue());
        buf.m_130077_(pkt.player);
        buf.m_130064_(pkt.pos);
        buf.writeLong(pkt.noteServerTime.longValue());
    }
}

