/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.midi;

import io.github.tofodroid.mods.mimi.common.MIMIMod;
import io.github.tofodroid.mods.mimi.common.midi.BasicMidiInfo;
import java.io.File;
import java.util.UUID;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequence;

public class LocalMidiInfo {
    public final Boolean serverFile;
    public final File file;
    public final UUID fileId;

    private LocalMidiInfo(File file, UUID fileId, Boolean serverFile) {
        this.serverFile = serverFile;
        this.file = file;
        this.fileId = fileId;
    }

    public UUID getFileId() {
        return this.fileId;
    }

    public Sequence loadSequenceFromFile() {
        try {
            return MidiSystem.getSequence(this.file);
        }
        catch (Exception e) {
            MIMIMod.LOGGER.error("Failed to load sequence: " + this.file.getAbsolutePath() + " - " + e.getMessage());
            return null;
        }
    }

    public BasicMidiInfo getBasicMidiInfo() {
        return new BasicMidiInfo(this.file.getName(), this.fileId, this.serverFile);
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof LocalMidiInfo)) {
            return false;
        }
        return ((LocalMidiInfo)other).getFileId().equals(this.getFileId());
    }

    public static LocalMidiInfo fromFile(File file, Boolean isServer) {
        if (file.exists()) {
            try {
                return new LocalMidiInfo(file, LocalMidiInfo.createFileId(file), isServer);
            }
            catch (Exception e) {
                MIMIMod.LOGGER.warn("Invalid MIDI file: " + file.getAbsolutePath());
            }
        }
        return null;
    }

    public static UUID createFileId(File file) {
        try {
            return UUID.nameUUIDFromBytes(file.getAbsolutePath().getBytes());
        }
        catch (Exception e) {
            MIMIMod.LOGGER.error("Failed to create file ID for file: " + file.getAbsolutePath(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

