/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.item;

import io.github.tofodroid.mods.mimi.client.gui.ClientGuiWrapper;
import io.github.tofodroid.mods.mimi.common.block.AConfigurableTileBlock;
import io.github.tofodroid.mods.mimi.common.block.BlockEffectEmitter;
import io.github.tofodroid.mods.mimi.common.block.BlockInstrument;
import io.github.tofodroid.mods.mimi.common.block.ModBlocks;
import io.github.tofodroid.mods.mimi.common.item.IInstrumentItem;
import io.github.tofodroid.mods.mimi.util.MidiNbtDataUtils;
import io.github.tofodroid.mods.mimi.util.TagUtils;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class ItemSettingsSync
extends Item {
    public static final String REGISTRY_NAME = "settingssync";
    public static final Integer INSTRUMENT_SETTING_TYPE = -1;
    public static final Integer NONE_SETTING_TYPE = -2;

    public ItemSettingsSync(Item.Properties props) {
        super(props.m_41487_(64));
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, level, tooltip, flagIn);
        Integer settingType = this.getSettingType(stack);
        if (settingType < 0) {
            tooltip.add((Component)Component.m_237113_((String)"Crouch + Right-Click Block to Copy Settings").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        } else {
            tooltip.add((Component)Component.m_237113_((String)"Right-Click Block of Same Type to Paste").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
            tooltip.add((Component)Component.m_237113_((String)""));
        }
        if (settingType == INSTRUMENT_SETTING_TYPE) {
            tooltip.add((Component)Component.m_237113_((String)"Instrument").m_130944_(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.BOLD, ChatFormatting.ITALIC}));
            IInstrumentItem.appendInstrumentTooltip(stack, tooltip);
        } else if (settingType >= 0) {
            AConfigurableTileBlock<?> block = ModBlocks.SETTINGS_SYNC_BLOCKS.get(settingType);
            tooltip.add((Component)block.m_49954_().m_130944_(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.BOLD, ChatFormatting.ITALIC}));
            block.m_5871_(stack, (BlockGetter)level, tooltip, flagIn);
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack heldItem = playerIn.m_21120_(handIn);
        if (worldIn.f_46443_ && !playerIn.m_6047_()) {
            Integer settingType = this.getSettingType(heldItem);
            if (settingType == INSTRUMENT_SETTING_TYPE) {
                ClientGuiWrapper.openInstrumentGui(worldIn, playerIn, null, handIn, heldItem);
                return InteractionResultHolder.m_19090_((Object)heldItem);
            }
            if (settingType >= 0) {
                ModBlocks.SETTINGS_SYNC_BLOCKS.get(settingType).openGuiWrapper().accept(worldIn, playerIn, null, handIn, heldItem);
                return InteractionResultHolder.m_19090_((Object)heldItem);
            }
        }
        return InteractionResultHolder.m_19098_((Object)heldItem);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        ItemStack heldItem = context.m_43722_();
        BlockState state = context.m_43725_().m_8055_(context.m_8083_());
        if (state.m_60734_() instanceof AConfigurableTileBlock) {
            AConfigurableTileBlock block = (AConfigurableTileBlock)state.m_60734_();
            BiFunction<ItemStack, ItemStack, ItemStack> copyFunction = ((Object)((Object)block)).equals((Object)ModBlocks.EFFECTEMITTER) ? BlockEffectEmitter::copyEffectEmitterSettings : MidiNbtDataUtils::copyMidiSettings;
            Integer blockSettingType = this.toSettingType(block);
            Integer stackSettingType = this.getSettingType(heldItem);
            if (blockSettingType >= -1) {
                if (context.m_7078_()) {
                    if (!context.m_43725_().f_46443_) {
                        ItemStack newStack = copyFunction.apply(block.getSourceStack(context.m_43725_(), context.m_8083_()), heldItem);
                        TagUtils.setOrRemoveInt(newStack, "setting_type", blockSettingType);
                        context.m_43723_().m_21008_(context.m_43724_(), newStack);
                        MutableComponent message = Component.m_237113_((String)"Copied ").m_7220_((Component)state.m_60734_().m_49954_()).m_7220_((Component)Component.m_237113_((String)" Settings to Synchronizer"));
                        context.m_43723_().m_5661_((Component)message, true);
                        return InteractionResult.PASS;
                    }
                    return InteractionResult.SUCCESS;
                }
                if (stackSettingType == blockSettingType) {
                    block.setSourceStack(context.m_43725_(), context.m_8083_(), copyFunction.apply(heldItem, block.getSourceStack(context.m_43725_(), context.m_8083_())));
                    MutableComponent message = Component.m_237113_((String)"Applied Synchronizer Settings to ").m_7220_((Component)state.m_60734_().m_49954_());
                    context.m_43723_().m_5661_((Component)message, true);
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return InteractionResult.PASS;
    }

    public Integer toSettingType(AConfigurableTileBlock<?> block) {
        if (block instanceof BlockInstrument) {
            return INSTRUMENT_SETTING_TYPE;
        }
        return ModBlocks.SETTINGS_SYNC_BLOCKS.indexOf(block);
    }

    public Integer getSettingType(ItemStack stack) {
        Integer raw = TagUtils.getIntOrDefault(stack, "setting_type", NONE_SETTING_TYPE);
        return raw >= NONE_SETTING_TYPE && raw < ModBlocks.SETTINGS_SYNC_BLOCKS.size() ? raw : NONE_SETTING_TYPE;
    }
}

