/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.item;

import io.github.tofodroid.mods.mimi.client.gui.ClientGuiWrapper;
import io.github.tofodroid.mods.mimi.common.block.ModBlocks;
import io.github.tofodroid.mods.mimi.common.config.ConfigProxy;
import io.github.tofodroid.mods.mimi.common.config.instrument.InstrumentConfig;
import io.github.tofodroid.mods.mimi.common.config.instrument.InstrumentSpec;
import io.github.tofodroid.mods.mimi.common.item.IInstrumentItem;
import io.github.tofodroid.mods.mimi.common.network.NoteEventPacket;
import io.github.tofodroid.mods.mimi.server.events.note.consumer.ServerNoteConsumerManager;
import io.github.tofodroid.mods.mimi.util.EntityUtils;
import io.github.tofodroid.mods.mimi.util.MidiNbtDataUtils;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;

public class ItemInstrumentHandheld
extends Item
implements IInstrumentItem {
    protected final String REGISTRY_NAME;
    protected final Byte instrumentId;
    protected final Integer defaultChannels;
    protected final Integer defaultColor;
    protected final Boolean colorable;

    public ItemInstrumentHandheld(Item.Properties props, Byte instrumentId) {
        super(props.m_41487_(1));
        InstrumentSpec spec = InstrumentConfig.getBydId(instrumentId);
        this.REGISTRY_NAME = spec.registryName;
        this.defaultChannels = MidiNbtDataUtils.getDefaultChannelsForBank(spec.midiBankNumber);
        this.instrumentId = instrumentId;
        this.colorable = spec.isColorable();
        this.defaultColor = this.colorable != false ? spec.defaultColor() : null;
    }

    public ItemInstrumentHandheld(Item.Properties props, InstrumentSpec spec) {
        super(props.m_41487_(1));
        this.REGISTRY_NAME = spec.registryName;
        this.defaultChannels = MidiNbtDataUtils.getDefaultChannelsForBank(spec.midiBankNumber);
        this.instrumentId = spec.instrumentId;
        this.colorable = spec.isColorable();
        this.defaultColor = this.colorable != false ? spec.defaultColor() : null;
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        this.appendSettingsTooltip(stack, tooltip);
    }

    @Override
    public Boolean isColorable() {
        return this.colorable;
    }

    @Override
    public Integer getDefaultColor() {
        return this.defaultColor;
    }

    @Override
    public Byte getInstrumentId() {
        return this.instrumentId;
    }

    public EquipmentSlot getEquipmentSlot(ItemStack stack) {
        return EquipmentSlot.OFFHAND;
    }

    public InteractionResult m_6880_(ItemStack stack, Player user, LivingEntity target, InteractionHand handIn) {
        if (target instanceof Player && user.m_6047_()) {
            if (!user.m_9236_().f_46443_) {
                MidiNbtDataUtils.setMidiSource(stack, target.m_20148_(), target.m_7755_().getString());
                user.m_21008_(handIn, stack);
                MutableComponent message = Component.m_237113_((String)"Linked ").m_7220_(stack.m_41786_()).m_7220_((Component)Component.m_237113_((String)" to ")).m_7220_(target.m_7755_());
                user.m_5661_((Component)message, true);
                ServerNoteConsumerManager.handlePacket(NoteEventPacket.createResetPacket(this.getInstrumentId(), user.m_20148_(), EntityUtils.getEntityHeadPos((LivingEntity)user), handIn), false, null, (ServerLevel)user.m_9236_());
            }
            return InteractionResult.SUCCESS;
        }
        if (target instanceof Mob) {
            if (!user.m_9236_().f_46443_ && ConfigProxy.getAllowedInstrumentMobs().contains(target.m_6095_().m_204041_().m_205785_().m_135782_().toString()) && !((Mob)target).m_255207_(stack).m_41619_()) {
                user.m_21008_(handIn, ItemStack.f_41583_);
                target.m_5496_(SoundEvents.f_11811_, 1.0f, 1.0f);
                ServerNoteConsumerManager.handlePacket(NoteEventPacket.createResetPacket(this.getInstrumentId(), user.m_20148_(), EntityUtils.getEntityHeadPos((LivingEntity)user), handIn), false, null, (ServerLevel)user.m_9236_());
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        if (worldIn.f_46443_) {
            ClientGuiWrapper.openInstrumentGui(worldIn, playerIn, null, handIn, playerIn.m_21120_(handIn));
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)playerIn.m_21120_(handIn));
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)playerIn.m_21120_(handIn));
    }

    public void m_142312_(CompoundTag tag) {
        ListTag listtag;
        if (tag == null) {
            return;
        }
        if (tag.m_128441_("inventory") && (listtag = tag.m_128469_("inventory").m_128437_("Items", 10)) != null && listtag.size() > 0) {
            for (int i = 0; i < listtag.size(); ++i) {
                CompoundTag stackTag = listtag.m_128728_(i);
                String itemId = stackTag.m_128461_("id");
                if (!itemId.equalsIgnoreCase("mimi:switchboard") || !stackTag.m_128425_("tag", 10)) continue;
                tag = tag.m_128391_(MidiNbtDataUtils.convertSwitchboardToDataTag(stackTag.m_128469_("tag")));
                tag.m_128473_("inventory");
            }
        }
    }

    public static ItemStack getEntityHeldInstrumentStack(LivingEntity entity, InteractionHand handIn) {
        ItemStack heldStack = entity.m_21120_(handIn);
        if (heldStack != null && heldStack.m_41720_() instanceof ItemInstrumentHandheld) {
            return heldStack;
        }
        return null;
    }

    public static Boolean isEntityHoldingInstrument(LivingEntity entity) {
        return ItemInstrumentHandheld.getEntityHeldInstrumentStack(entity, InteractionHand.MAIN_HAND) != null || ItemInstrumentHandheld.getEntityHeldInstrumentStack(entity, InteractionHand.OFF_HAND) != null;
    }

    public static Byte getEntityHeldInstrumentId(LivingEntity entity, InteractionHand handIn) {
        ItemStack instrumentStack = ItemInstrumentHandheld.getEntityHeldInstrumentStack(entity, handIn);
        if (instrumentStack != null) {
            return ((ItemInstrumentHandheld)instrumentStack.m_41720_()).getInstrumentId();
        }
        return null;
    }

    @Override
    public Integer getDefaultChannels() {
        return this.defaultChannels;
    }

    @Override
    public String getRegistryName() {
        return this.REGISTRY_NAME;
    }

    public boolean doesSneakBypassUse(ItemStack stack, LevelReader level, BlockPos pos, Player player) {
        Block block = level.m_8055_(pos).m_60734_();
        return block.equals((Object)ModBlocks.TRANSMITTERBLOCK) || block.equals((Object)ModBlocks.RELAY);
    }
}

