/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.entity;

import io.github.tofodroid.mods.mimi.common.entity.ModEntities;
import io.github.tofodroid.mods.mimi.common.tile.TileInstrument;
import io.github.tofodroid.mods.mimi.server.events.broadcast.consumer.instrument.EntityInstrumentConsumerEventHandler;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import org.joml.Vector3d;

public class EntitySeat
extends Entity {
    protected BlockPos source;
    protected Player rider;

    public EntitySeat(EntityType<? extends EntitySeat> type, Level world) {
        super(type, world);
        this.f_19794_ = true;
    }

    private EntitySeat(Level world, BlockPos source, Vector3d offset, Player rider) {
        this(ModEntities.SEAT, world);
        this.source = source;
        this.m_6034_((double)source.m_123341_() + offset.x, (double)source.m_123342_() + offset.y, (double)source.m_123343_() + offset.z);
        if (rider != null) {
            this.rider = rider;
            rider.m_20329_((Entity)this);
        }
    }

    public boolean m_6063_() {
        return false;
    }

    public Player getRider() {
        return this.rider;
    }

    public void m_142687_(Entity.RemovalReason p_146834_) {
        if (!this.m_9236_().f_46443_) {
            this.m_20153_();
            if (this.rider != null) {
                EntityInstrumentConsumerEventHandler.reloadEntityInstrumentConsumers((LivingEntity)this.rider);
            }
            this.m_9236_().m_46717_(this.source, this.m_9236_().m_8055_(this.source).m_60734_());
        }
        super.m_142687_(p_146834_);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            BlockEntity blockEntity = this.m_9236_().m_7702_(this.source);
            if (this.source == null || this.m_20197_().isEmpty() || blockEntity == null || !(blockEntity instanceof TileInstrument) || this.m_20197_().stream().allMatch(e -> !e.isAddedToWorld() || !e.m_6084_() || !(e instanceof Player))) {
                this.m_146870_();
            }
        }
        if (this.source == null) {
            this.source = this.m_20183_();
        }
    }

    public double m_6048_() {
        return -0.2;
    }

    public BlockPos getSource() {
        return this.source;
    }

    public static Boolean seatExists(Level world, BlockPos pos, Vector3d sitOffsetPos) {
        EntitySeat newSeat = new EntitySeat(world, pos, sitOffsetPos, null);
        return EntitySeat.seatExists(world, newSeat.m_20185_(), newSeat.m_20186_(), newSeat.m_20189_());
    }

    public static EntitySeat getExisting(Level world, BlockPos pos, Vector3d sitOffsetPos) {
        EntitySeat newSeat = new EntitySeat(world, pos, sitOffsetPos, null);
        return EntitySeat.getExisting(world, newSeat.m_20185_(), newSeat.m_20186_(), newSeat.m_20189_());
    }

    private static Boolean seatExists(Level world, Double posX, Double posY, Double posZ) {
        List seats = world.m_45976_(EntitySeat.class, new AABB(posX - 0.05, posY - 0.05, posZ - 0.05, posX + 0.05, posY + 0.05, posZ + 0.05));
        return !seats.isEmpty();
    }

    private static EntitySeat getExisting(Level world, Double posX, Double posY, Double posZ) {
        List seats = world.m_45976_(EntitySeat.class, new AABB(posX - 0.05, posY - 0.05, posZ - 0.05, posX + 0.05, posY + 0.05, posZ + 0.05));
        if (!seats.isEmpty()) {
            return (EntitySeat)((Object)seats.get(0));
        }
        return null;
    }

    public static EntitySeat create(Level world, BlockPos pos, Vector3d sitOffsetPos, Player player) {
        EntitySeat newSeat;
        if (!world.f_46443_ && !EntitySeat.seatExists(world, (newSeat = new EntitySeat(world, pos, sitOffsetPos, player)).m_20185_(), newSeat.m_20186_(), newSeat.m_20189_()).booleanValue()) {
            world.m_7967_((Entity)newSeat);
            player.m_7998_((Entity)newSeat, false);
            EntityInstrumentConsumerEventHandler.reloadEntityInstrumentConsumers((LivingEntity)player);
            return newSeat;
        }
        return null;
    }

    protected void m_7378_(CompoundTag tag) {
        this.source = new BlockPos(tag.m_128451_("source_x"), tag.m_128451_("source_y"), tag.m_128451_("source_z"));
    }

    protected void m_7380_(CompoundTag tag) {
        if (this.source != null) {
            tag.m_128405_("source_x", this.source.m_123341_());
            tag.m_128405_("source_y", this.source.m_123342_());
            tag.m_128405_("source_z", this.source.m_123342_());
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    protected void m_8097_() {
    }
}

