/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.block;

import io.github.tofodroid.mods.mimi.client.gui.ClientGuiWrapper;
import io.github.tofodroid.mods.mimi.common.block.AContainerBlock;
import io.github.tofodroid.mods.mimi.common.item.IInstrumentItem;
import io.github.tofodroid.mods.mimi.common.item.ModItems;
import io.github.tofodroid.mods.mimi.common.tile.ModTiles;
import io.github.tofodroid.mods.mimi.common.tile.TileTransmitter;
import io.github.tofodroid.mods.mimi.server.events.broadcast.BroadcastManager;
import io.github.tofodroid.mods.mimi.server.events.broadcast.producer.transmitter.ServerTransmitterManager;
import io.github.tofodroid.mods.mimi.util.MidiNbtDataUtils;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;

public class BlockTransmitter
extends AContainerBlock<TileTransmitter> {
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final String REGISTRY_NAME = "transmitterblock";

    public BlockTransmitter(BlockBehaviour.Properties props) {
        super(props.m_155956_(6.0f).m_60978_(2.0f).m_60918_(SoundType.f_56736_));
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        TileTransmitter tile = (TileTransmitter)((Object)this.getTileForBlock(level, pos));
        if ((stack.m_41720_() instanceof IInstrumentItem || stack.m_41720_().equals(ModItems.RECEIVER) || stack.m_41720_().equals(ModItems.RELAY) || stack.m_41720_().equals((Object)ModItems.SOURCELINKER)) && tile != null && player.m_6047_()) {
            if (!level.f_46443_) {
                String transmitterName = level.m_46472_().m_135782_().m_135815_() + "@(" + pos.m_123344_() + ")";
                MidiNbtDataUtils.setMidiSourceFromTransmitter(stack, tile.getUUID(), transmitterName);
                player.m_21008_(player.m_7655_(), stack);
                MutableComponent message = Component.m_237113_((String)"Linked ").m_7220_(stack.m_41786_()).m_7220_((Component)Component.m_237113_((String)" to ")).m_7220_((Component)this.m_49954_());
                player.m_5661_((Component)message, true);
            }
            return InteractionResult.SUCCESS;
        }
        if (tile != null && level.f_46443_) {
            ClientGuiWrapper.openTransmitterBlockGui(level, tile.getUUID());
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> state) {
        state.m_61104_(new Property[]{POWERED});
    }

    @Override
    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_155947_() || state.m_60734_() == newState.m_60734_()) {
            return;
        }
        TileTransmitter tileEntity = (TileTransmitter)((Object)this.getTileForBlock(worldIn, pos));
        if (!worldIn.f_46443_ && tileEntity != null) {
            BroadcastManager.removeBroadcastProducer(tileEntity.getUUID());
        }
        super.m_6810_(state, worldIn, pos, newState, isMoving);
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        TileTransmitter tileEntity = (TileTransmitter)((Object)this.getTileForBlock(worldIn, pos));
        if (tileEntity != null) {
            ItemStack newStack = new ItemStack((ItemLike)stack.m_41720_(), 1);
            newStack.m_41751_(stack.m_41784_().m_6426_());
            tileEntity.setSourceStack(newStack);
            if (!worldIn.f_46443_) {
                ServerTransmitterManager.createTransmitter(tileEntity);
            }
        }
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        return Arrays.asList(new ItemStack[0]);
    }

    @Override
    public BlockEntityType<TileTransmitter> getTileType() {
        return ModTiles.TRANSMITTER;
    }

    public int m_6378_(BlockState state, BlockGetter getter, BlockPos pos, Direction direction) {
        return (Boolean)state.m_61143_((Property)POWERED) != false ? 15 : 0;
    }

    public boolean m_7899_(BlockState p_55730_) {
        return true;
    }
}

