/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.block;

import io.github.tofodroid.mods.mimi.client.gui.ClientGuiWrapper;
import io.github.tofodroid.mods.mimi.common.block.AConfigurableTileBlock;
import io.github.tofodroid.mods.mimi.common.config.instrument.InstrumentConfig;
import io.github.tofodroid.mods.mimi.common.config.instrument.InstrumentSpec;
import io.github.tofodroid.mods.mimi.common.entity.EntitySeat;
import io.github.tofodroid.mods.mimi.common.entity.ModEntities;
import io.github.tofodroid.mods.mimi.common.item.ModItems;
import io.github.tofodroid.mods.mimi.common.tile.ModTiles;
import io.github.tofodroid.mods.mimi.common.tile.TileInstrument;
import io.github.tofodroid.mods.mimi.util.MidiNbtDataUtils;
import io.github.tofodroid.mods.mimi.util.VoxelShapeUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockInstrument
extends AConfigurableTileBlock<TileInstrument>
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final DirectionProperty DIRECTION = BlockStateProperties.f_61374_;
    protected final Map<Direction, VoxelShape> SHAPES;
    protected final Byte instrumentId;
    protected final Integer defaultChannels;
    protected final Integer defaultColor;
    protected final Boolean colorable;
    protected final String REGISTRY_NAME;

    public BlockInstrument(BlockBehaviour.Properties props, Byte instrumentId) {
        super(props.m_155956_(6.0f).m_60978_(2.0f).m_60918_(SoundType.f_56736_).m_60988_().m_60955_());
        InstrumentSpec spec = InstrumentConfig.getBydId(instrumentId);
        this.SHAPES = this.generateShapes(VoxelShapeUtils.loadFromStrings(spec.collisionShapes));
        this.REGISTRY_NAME = spec.registryName;
        this.defaultChannels = MidiNbtDataUtils.getDefaultChannelsForBank(spec.midiBankNumber);
        this.instrumentId = instrumentId;
        this.colorable = spec.isColorable();
        this.defaultColor = this.colorable != false ? spec.defaultColor() : null;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)DIRECTION, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockInstrument(BlockBehaviour.Properties props, InstrumentSpec spec) {
        super(props.m_155956_(6.0f).m_60978_(2.0f).m_60918_(SoundType.f_56736_).m_60988_().m_60955_());
        this.SHAPES = this.generateShapes(VoxelShapeUtils.loadFromStrings(spec.collisionShapes));
        this.REGISTRY_NAME = spec.registryName;
        this.defaultChannels = MidiNbtDataUtils.getDefaultChannelsForBank(spec.midiBankNumber);
        this.instrumentId = spec.instrumentId;
        this.colorable = spec.isColorable();
        this.defaultColor = this.colorable != false ? spec.defaultColor() : null;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)DIRECTION, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected Map<Direction, VoxelShape> generateShapes(VoxelShape shape) {
        return VoxelShapeUtils.generateFacingShape(shape);
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        TileInstrument tileInstrument = (TileInstrument)((Object)this.getTileForBlock(worldIn, pos));
        if (this.shouldSkipUse(state, worldIn, pos, player, hand).booleanValue()) {
            return worldIn.f_46443_ ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        if (tileInstrument != null) {
            if (!worldIn.f_46443_) {
                if (player.m_20202_() == null) {
                    tileInstrument.attemptSit(player);
                }
            } else if (((Object)((Object)tileInstrument)).equals((Object)BlockInstrument.getTileInstrumentForEntity((LivingEntity)player))) {
                ClientGuiWrapper.openInstrumentGui(worldIn, player, null, null, tileInstrument.getSourceStack());
            }
        }
        return InteractionResult.SUCCESS;
    }

    public boolean m_7420_(BlockState state, BlockGetter getter, BlockPos pos) {
        return true;
    }

    @Override
    public BlockEntityType<TileInstrument> getTileType() {
        return ModTiles.INSTRUMENT;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> state) {
        state.m_61104_(new Property[]{DIRECTION, WATERLOGGED});
    }

    @Override
    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        super.m_6810_(state, worldIn, pos, newState, isMoving);
    }

    @Override
    public ItemStack m_7397_(BlockGetter reader, BlockPos pos, BlockState state) {
        TileInstrument tileInstrument = reader.m_141902_(pos, ModTiles.INSTRUMENT).orElse(null);
        if (tileInstrument != null) {
            return tileInstrument.getSourceStack();
        }
        return super.m_7397_(reader, pos, state);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction = context.m_8125_().m_122424_();
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)DIRECTION, (Comparable)direction)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return this.SHAPES.get(state.m_61143_((Property)DIRECTION));
    }

    public FluidState m_5888_(BlockState p_51581_) {
        return (Boolean)p_51581_.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(p_51581_);
    }

    public BlockState rotate(BlockState state, LevelAccessor world, BlockPos pos, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)DIRECTION, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)DIRECTION)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)DIRECTION)));
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        TileInstrument tile = (TileInstrument)super.m_142194_(pos, state);
        return tile;
    }

    @Override
    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity tileEntity = worldIn.m_7702_(pos);
        if (tileEntity instanceof TileInstrument) {
            ItemStack newStack = new ItemStack((ItemLike)stack.m_41720_(), stack.m_41613_());
            newStack.m_41751_(stack.m_41784_().m_6426_());
            ((TileInstrument)tileEntity).setSourceStack(newStack);
        }
    }

    @Override
    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        return Arrays.asList(new ItemStack[0]);
    }

    public String getRegistryName() {
        return this.REGISTRY_NAME;
    }

    public Boolean isColorable() {
        return this.colorable;
    }

    public Integer getDefaultColor() {
        return this.defaultColor;
    }

    public Byte getInstrumentId() {
        return this.instrumentId;
    }

    public Integer getDefaultChannels() {
        return this.defaultChannels;
    }

    public static Boolean isEntitySittingAtInstrument(LivingEntity entity) {
        return entity.m_20159_() && entity.m_20202_() != null && ModEntities.SEAT.equals((Object)entity.m_20202_().m_6095_());
    }

    public static EntitySeat getSeatForEntity(LivingEntity entity) {
        if (BlockInstrument.isEntitySittingAtInstrument(entity).booleanValue()) {
            return (EntitySeat)entity.m_20202_();
        }
        return null;
    }

    public static ItemStack getTileInstrumentStackForEntity(LivingEntity entity) {
        TileInstrument tile = BlockInstrument.getTileInstrumentForEntity(entity);
        if (tile != null) {
            return tile.getSourceStack();
        }
        return null;
    }

    public static TileInstrument getTileInstrumentForEntity(LivingEntity entity) {
        BlockPos pos;
        if (entity.m_6084_() && BlockInstrument.isEntitySittingAtInstrument(entity).booleanValue() && (pos = BlockInstrument.getSeatForEntity(entity).getSource()) != null && Level.m_46741_((BlockPos)pos)) {
            BlockEntity sourceEntity = entity.m_9236_().m_7702_(BlockInstrument.getSeatForEntity(entity).getSource());
            return sourceEntity != null && sourceEntity instanceof TileInstrument ? (TileInstrument)sourceEntity : null;
        }
        return null;
    }

    @Override
    public AConfigurableTileBlock.OpenGuiWrapper openGuiWrapper() {
        return ClientGuiWrapper::openInstrumentGui;
    }

    @Override
    protected void appendSettingsTooltip(ItemStack blockItemStack, List<Component> tooltip) {
    }

    @Override
    protected Boolean shouldSkipUse(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand hand) {
        Item useItem = player.m_21120_(hand).m_41720_();
        return useItem.equals((Object)ModItems.SETTINGSSYNC) || useItem.equals((Object)ModItems.SOURCELINKER);
    }
}

