/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.api.event.broadcast;

import io.github.tofodroid.mods.mimi.common.MIMIMod;
import io.github.tofodroid.mods.mimi.common.api.event.broadcast.BroadcastConsumerMapping;
import io.github.tofodroid.mods.mimi.common.api.event.broadcast.BroadcastEvent;
import io.github.tofodroid.mods.mimi.common.api.event.broadcast.IBroadcastConsumer;
import io.github.tofodroid.mods.mimi.server.ServerExecutorProxy;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

public interface IBroadcastProducer
extends AutoCloseable {
    public UUID getOwnerId();

    public BlockPos getBroadcastPos();

    public Integer getBroadcastRange();

    public ResourceKey<Level> getBroadcastDimension();

    public BroadcastConsumerMapping getConsumers();

    public void linkConsumers(List<IBroadcastConsumer> var1);

    default public void reindex() {
        this.getConsumers().reindex();
    }

    public void tickProducer();

    public void onProducerRemoved();

    default public void reset() {
        this.broadcast(BroadcastEvent.reset(this.getOwnerId(), this.getBroadcastDimension(), this.getBroadcastPos(), MIMIMod.getProxy().getCurrentServerMillis()));
    }

    default public void broadcast(BroadcastEvent event) {
        if (event == null) {
            return;
        }
        BroadcastConsumerMapping consumers = this.getConsumers();
        if (consumers != null && !consumers.isEmpty().booleanValue()) {
            for (IBroadcastConsumer consumer : consumers.getConsumersForChannel(event.channel)) {
                ServerExecutorProxy.executeOnServerThread(() -> consumer.consumeEvent(event));
            }
        }
    }
}

