/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.api.event.broadcast;

import io.github.tofodroid.mods.mimi.common.api.event.broadcast.BroadcastEvent;
import io.github.tofodroid.mods.mimi.common.api.event.broadcast.IBroadcastConsumer;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class BroadcastConsumerMapping {
    protected final UUID broadcasterId;
    private List<IBroadcastConsumer>[] CHANNEL_CONSUMERS = new ArrayList[16];
    private List<IBroadcastConsumer> LINKED_CONSUMERS = new ArrayList<IBroadcastConsumer>();

    public BroadcastConsumerMapping(UUID broadcasterId, List<IBroadcastConsumer> linkedConsumers) {
        for (int i = 0; i < 16; ++i) {
            this.CHANNEL_CONSUMERS[i] = new ArrayList<IBroadcastConsumer>(0);
        }
        this.broadcasterId = broadcasterId;
        this.LINKED_CONSUMERS = linkedConsumers;
        this.reindex();
    }

    public void reindex() {
        for (int i = 0; i < 16; ++i) {
            this.CHANNEL_CONSUMERS[i].clear();
        }
        for (IBroadcastConsumer consumer : this.LINKED_CONSUMERS) {
            if (consumer.getEnabledChannelsList() == null) continue;
            for (Byte enabledChannel : consumer.getEnabledChannelsList()) {
                this.CHANNEL_CONSUMERS[enabledChannel].add(consumer);
            }
        }
    }

    public Boolean isEmpty() {
        return this.LINKED_CONSUMERS.isEmpty();
    }

    public List<IBroadcastConsumer> getConsumersForChannel(Byte channel) {
        if (channel == BroadcastEvent.ALL_CHANNELS) {
            return this.LINKED_CONSUMERS;
        }
        return this.CHANNEL_CONSUMERS[channel];
    }
}

