/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.api.event.broadcast;

import io.github.tofodroid.mods.mimi.common.api.event.broadcast.IBroadcastConsumer;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class BroadcastConsumerInventoryHolder {
    private final UUID ownerId;
    private final Map<Integer, IBroadcastConsumer> holderMap = new Int2ObjectArrayMap();

    public BroadcastConsumerInventoryHolder(UUID ownerId) {
        this.ownerId = ownerId;
    }

    public Boolean isEmpty() {
        return this.holderMap.isEmpty();
    }

    public void putConsumer(Integer slot, IBroadcastConsumer consumer) {
        this.holderMap.put(slot, consumer);
    }

    public IBroadcastConsumer removeConsumer(Integer slot) {
        return this.holderMap.remove(slot);
    }

    public IBroadcastConsumer getConsumer(Integer slot) {
        return this.holderMap.get(slot);
    }

    public List<IBroadcastConsumer> getConsumers() {
        if (this.holderMap.isEmpty()) {
            return new ArrayList<IBroadcastConsumer>(0);
        }
        return new ArrayList<IBroadcastConsumer>(this.holderMap.values());
    }

    public UUID getOwnerId() {
        return this.ownerId;
    }
}

