/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.client.midi.synth;

import io.github.tofodroid.com.sun.media.sound.SoftChannelProxy;
import io.github.tofodroid.mods.mimi.client.midi.synth.MIMISynthUtils;
import io.github.tofodroid.mods.mimi.common.api.event.note.NoteEvent;
import io.github.tofodroid.mods.mimi.common.config.instrument.InstrumentSpec;
import io.github.tofodroid.mods.mimi.util.ByteUtils;
import io.github.tofodroid.mods.mimi.util.EntityUtils;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class MIMIChannel {
    public static final Integer MIDI_CHANNEL_IDLE_SECONDS = 8;
    public static final Integer MAX_NOTE_DIST = 2 * NoteEvent.NOTE_DEF_RANGE;
    protected final SoftChannelProxy channel;
    protected final Integer channelNum;
    protected Instant lastNoteTime;
    protected BlockPos lastNotePos;
    protected Integer pitchBendRange = 256;

    public MIMIChannel(Integer channelNum, SoftChannelProxy channel) {
        this.channelNum = channelNum;
        this.channel = channel;
        this.setVolume(ByteUtils.ZERO);
        this.reset();
    }

    public void setInstrument(InstrumentSpec instrument) {
        this.channel.programChange(instrument.midiBankNumber * 128, instrument.midiPatchNumber);
        this.setVolume(ByteUtils.ZERO);
        this.reset();
    }

    public void clear() {
        this.lastNoteTime = null;
        this.pitchBendRange = 256;
        this.setVolume(ByteUtils.ZERO);
        this.reset();
    }

    public void noteOn(BlockPos notePos) {
        this.lastNoteTime = Instant.now();
        this.lastNotePos = notePos;
    }

    public void reset() {
        if (this.channel != null) {
            this.channel.resetAllControllers(true);
            this.channel.allSoundOff();
        }
        this.pitchBendRange = 256;
    }

    public void setVolume(Byte volume) {
        this.channel.controlChange(7, volume.byteValue());
    }

    public void setLRPan(Byte lrPan) {
        this.channel.controlChange(10, lrPan.byteValue());
    }

    public void setPitchBendRange(Integer range) {
        if (range != this.pitchBendRange && this.channel.getChannel() != null) {
            this.channel.getChannel().rpnChange(0, range);
            this.pitchBendRange = range;
        }
    }

    public Boolean tick(Player clientPlayer, Boolean isClientChannel) {
        if (!this.isIdle().booleanValue() && this.lastNotePos != null) {
            double lastNoteDist = Math.abs(Math.sqrt(EntityUtils.getEntityHeadPos((LivingEntity)clientPlayer).m_123331_((Vec3i)this.lastNotePos)));
            if (lastNoteDist <= (double)MAX_NOTE_DIST.intValue()) {
                if (!isClientChannel.booleanValue()) {
                    this.channel.controlChange(7, MIMISynthUtils.getVolumeForRelativeNotePosition(clientPlayer.m_146892_(), this.lastNotePos).byteValue());
                    this.channel.controlChange(10, MIMISynthUtils.getLRPanForRelativeNotePosition(clientPlayer.m_146892_(), this.lastNotePos, Float.valueOf(clientPlayer.m_6080_())).byteValue());
                } else {
                    this.channel.controlChange(7, MIMISynthUtils.getVolumeForRelativeNoteDistance(0.0).byteValue());
                    this.channel.controlChange(10, 63);
                }
                return true;
            }
            this.reset();
        }
        return false;
    }

    public Integer getChannelNumber() {
        return this.channelNum;
    }

    protected Boolean isIdle() {
        if (this.lastNoteTime != null) {
            return Math.abs(ChronoUnit.SECONDS.between(Instant.now(), this.lastNoteTime)) > (long)MIDI_CHANNEL_IDLE_SECONDS.intValue();
        }
        return true;
    }
}

