/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.client.midi.synth;

import io.github.tofodroid.com.sun.media.sound.SoftChannelProxy;
import io.github.tofodroid.com.sun.media.sound.SoftSynthesizer;
import io.github.tofodroid.mods.mimi.client.midi.synth.AMIMISynth;
import io.github.tofodroid.mods.mimi.client.midi.synth.MIMIChannel;
import io.github.tofodroid.mods.mimi.common.config.ConfigProxy;
import io.github.tofodroid.mods.mimi.common.network.NoteEventPacket;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import javax.sound.midi.Soundbank;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.SourceDataLine;
import net.minecraft.world.entity.player.Player;

public class BroadcastedNoteMIMISynth
extends AMIMISynth<MIMIChannel> {
    protected SoftSynthesizer internalSynth;

    public BroadcastedNoteMIMISynth(AudioFormat format, SourceDataLine dataLine, Boolean jitterCorrection, Integer latency, Soundbank sounds) {
        super(format, dataLine, jitterCorrection, latency, sounds);
    }

    @Override
    public Map<String, Object> getSynthParams(Boolean jitterCorrection, Integer latency) {
        Map<String, Object> params = super.getSynthParams(true, latency);
        params.put("midi channels", ConfigProxy.getSynthChannels());
        params.put("max polyphony", ConfigProxy.getSynthChannels() * 4);
        return params;
    }

    @Override
    public Boolean tick(Player clientPlayer) {
        if (this.channelAssignmentMap != null && !this.channelAssignmentMap.isEmpty()) {
            ArrayList<MIMIChannel> toRemove = new ArrayList<MIMIChannel>();
            for (MIMIChannel channel : this.channelAssignmentMap.keySet()) {
                UUID playerId;
                if (channel.tick(clientPlayer, (playerId = this.getUUIDFromChannelId((String)this.channelAssignmentMap.get((Object)channel))).toString().equals(clientPlayer.m_20148_().toString())).booleanValue()) continue;
                toRemove.add(channel);
            }
            for (MIMIChannel remove : toRemove) {
                remove.clear();
                this.channelAssignmentMap.remove((Object)remove);
            }
            return true;
        }
        return false;
    }

    @Override
    protected MIMIChannel createChannel(Integer num, SoftChannelProxy channel) {
        return new MIMIChannel(num, channel);
    }

    @Override
    protected String createChannelId(NoteEventPacket message) {
        return message.player.toString() + "$" + message.instrumentId.toString() + "$" + message.channel.toString();
    }

    protected UUID getUUIDFromChannelId(String channelId) {
        return UUID.fromString(channelId.substring(0, channelId.indexOf("$")));
    }

    protected Byte getInstrumentIdFromChannelId(String channelId) {
        return Byte.valueOf(channelId.substring(channelId.indexOf("$") + 1, channelId.lastIndexOf("$")));
    }

    protected Byte getChannelFromChannelId(String channelId) {
        return Byte.valueOf(channelId.substring(channelId.lastIndexOf("$") + 1));
    }
}

