/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.client.midi;

import io.github.tofodroid.com.sun.media.sound.MidiUtils;
import io.github.tofodroid.mods.mimi.client.ClientProxy;
import io.github.tofodroid.mods.mimi.common.MIMIMod;
import io.github.tofodroid.mods.mimi.common.api.event.MidiEventType;
import io.github.tofodroid.mods.mimi.common.api.event.broadcast.BroadcastEvent;
import io.github.tofodroid.mods.mimi.common.api.event.note.NoteEvent;
import io.github.tofodroid.mods.mimi.common.config.ConfigProxy;
import io.github.tofodroid.mods.mimi.common.network.BroadcastEventPacket;
import io.github.tofodroid.mods.mimi.common.network.NetworkProxy;
import io.github.tofodroid.mods.mimi.common.network.NoteEventPacket;
import io.github.tofodroid.mods.mimi.util.EntityUtils;
import io.github.tofodroid.mods.mimi.util.MathUtils;
import io.github.tofodroid.mods.mimi.util.MidiNbtDataUtils;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.tuple.Pair;

public class MidiDeviceInputReceiver
implements Receiver {
    public static final Integer MAX_MIDI_DEVICE_VOLUME = 10;
    private volatile boolean open = true;
    private volatile Integer pitchBendRange = 256;
    private volatile Integer pitchBendStatus = 0;

    @Override
    public void send(MidiMessage msg, long timeStamp) {
        if (this.open && msg instanceof ShortMessage) {
            ShortMessage smsg = (ShortMessage)msg;
            Integer pitchBendCheck = MidiUtils.isPitchBendRangeMessage(smsg, this.pitchBendStatus);
            if (pitchBendCheck == 4) {
                this.pitchBendRange = smsg.getData2();
                this.pitchBendStatus = 0;
            }
            this.handleMessage(smsg);
        }
    }

    @Override
    public void close() {
        this.open = false;
    }

    protected void handleMessage(ShortMessage message) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && MIMIMod.getProxy().isClient().booleanValue()) {
            BroadcastEvent event;
            BroadcastEvent tempE = BroadcastEvent.fromShortMessage(message, player.m_20148_(), (ResourceKey<Level>)player.m_9236_().m_46472_(), EntityUtils.getEntityHeadPos((LivingEntity)player), 16, MathUtils.addClamped(message.getData2(), ConfigProxy.getMidiDeviceVelocity(), (Integer)0, (Integer)127));
            BroadcastEvent broadcastEvent = event = tempE.type == MidiEventType.PITCH_BEND ? (BroadcastEvent)tempE.withExtData(this.pitchBendRange) : tempE;
            if (event != null) {
                ((ClientProxy)MIMIMod.getProxy()).getMidiData().inputDeviceManager.getLocalInstrumentsForMidiDevice((Player)player, Integer.valueOf(message.getChannel()).byteValue()).forEach(arg_0 -> this.lambda$handleMessage$0(event, (Player)player, arg_0));
                if (((ClientProxy)MIMIMod.getProxy()).getMidiData().inputDeviceManager.getTransmitMidiInput().booleanValue()) {
                    BroadcastEventPacket packet = BroadcastEventPacket.fromBroadcastEvent(event);
                    NetworkProxy.sendToServer(packet);
                }
            }
        }
    }

    private void playInstrument(BroadcastEvent event, Player player, InteractionHand hand, ItemStack instrument) {
        NoteEvent nevent = new NoteEvent(event.type, true, MidiNbtDataUtils.getInstrumentId(instrument), hand, event.channel, event.note, event.type == MidiEventType.NOTE_ON ? MidiNbtDataUtils.applyInstrumentVolume(instrument, event.velocity) : event.velocity, event.senderId, (ResourceKey<Level>)event.dimension, event.pos, event.eventTime);
        if (event.type == MidiEventType.PITCH_BEND) {
            nevent = (NoteEvent)nevent.withExtData(event.extData);
        }
        NoteEventPacket packet = NoteEventPacket.fromNoteEvent(nevent);
        NetworkProxy.sendToServer(packet);
        ((ClientProxy)MIMIMod.getProxy()).getMidiSynth().handleLocalPacketInstant(packet);
    }

    private /* synthetic */ void lambda$handleMessage$0(BroadcastEvent event, Player player, Pair instrumentStack) {
        this.playInstrument(event, player, (InteractionHand)instrumentStack.getLeft(), (ItemStack)instrumentStack.getRight());
    }
}

