/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.client.gui.widget;

import io.github.tofodroid.mods.mimi.client.gui.CommonGuiUtils;
import io.github.tofodroid.mods.mimi.client.gui.widget.BaseWidget;
import io.github.tofodroid.mods.mimi.util.MidiNbtDataUtils;
import io.github.tofodroid.mods.mimi.util.Vector2Int;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.item.ItemStack;

public class MidiChannelToggleWidget
extends BaseWidget {
    private static final Vector2Int ALL_MIDI_BUTTON_COORDS = new Vector2Int(3, 17);
    private static final Vector2Int CLEAR_MIDI_BUTTON_COORDS = new Vector2Int(3, 42);
    private static final Vector2Int GEN_MIDI_BUTTON_COORDS = new Vector2Int(22, 17);
    private ItemStack midiStack;

    public MidiChannelToggleWidget(ItemStack midiStack, Vector2Int screenOffset, Vector2Int start) {
        super("textures/gui/widget/midi_channel_toggle.png", 173, new Vector2Int(173, 67), screenOffset, start);
        this.midiStack = midiStack;
    }

    @Override
    public void renderGraphics(GuiGraphics graphics, Integer mouseX, Integer mouseY) {
        super.renderGraphics(graphics, mouseX, mouseY);
        List<Byte> acceptedChannels = MidiNbtDataUtils.getEnabledChannelsList(this.midiStack);
        if (acceptedChannels != null && !acceptedChannels.isEmpty()) {
            for (Byte channelId : acceptedChannels) {
                this.blitAbsolute(graphics, this.GUI_TEXTURE, this.ABSOLUTE_START.x() + 28 + channelId % 8 * 19, this.ABSOLUTE_START.y() + 35 + channelId / 8 * 25, 0.0f, 67.0f, 3, 3, this.TEXTURE_SIZE, this.TEXTURE_SIZE);
            }
        }
    }

    @Override
    protected Boolean mouseClicked(Vector2Int localMouseCoords, Integer mouseButton) {
        if (CommonGuiUtils.clickedBox(localMouseCoords.x(), localMouseCoords.y(), CLEAR_MIDI_BUTTON_COORDS).booleanValue()) {
            MidiNbtDataUtils.clearEnabledChannels(this.midiStack);
            return true;
        }
        if (CommonGuiUtils.clickedBox(localMouseCoords.x(), localMouseCoords.y(), ALL_MIDI_BUTTON_COORDS).booleanValue()) {
            MidiNbtDataUtils.setEnableAllChannels(this.midiStack);
            return true;
        }
        for (byte i = 0; i < 16; i = (byte)(i + 1)) {
            Vector2Int buttonCoords = new Vector2Int(GEN_MIDI_BUTTON_COORDS.x() + i % 8 * 19, GEN_MIDI_BUTTON_COORDS.y() + i / 8 * 25);
            if (!CommonGuiUtils.clickedBox(localMouseCoords.x(), localMouseCoords.y(), buttonCoords).booleanValue()) continue;
            MidiNbtDataUtils.toggleChannel(this.midiStack, i);
            return true;
        }
        return false;
    }
}

