/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.client.gui.widget;

import io.github.tofodroid.mods.mimi.client.gui.CommonGuiUtils;
import io.github.tofodroid.mods.mimi.client.gui.widget.BaseWidget;
import io.github.tofodroid.mods.mimi.util.MidiNbtDataUtils;
import io.github.tofodroid.mods.mimi.util.Vector2Int;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.item.ItemStack;

public class BroadcastRangeWidget
extends BaseWidget {
    private static final Vector2Int BUTTON_COORDS = new Vector2Int(0, 0);
    private ItemStack midiStack;

    public BroadcastRangeWidget(ItemStack midiStack, Vector2Int screenOffset, Vector2Int start) {
        super("textures/gui/widget/broadcast_range.png", 65, new Vector2Int(17, 17), screenOffset, start);
        this.midiStack = midiStack;
    }

    @Override
    public void renderGraphics(GuiGraphics graphics, Integer mouseX, Integer mouseY) {
        super.renderGraphics(graphics, mouseX, mouseY);
        this.blitAbsolute(graphics, this.GUI_TEXTURE, this.ABSOLUTE_START.x() + 2, this.ABSOLUTE_START.y() + 2, 13 * MidiNbtDataUtils.getBroadcastRange(this.midiStack), 17.0f, 13, 13, this.TEXTURE_SIZE, this.TEXTURE_SIZE);
    }

    @Override
    protected Boolean mouseClicked(Vector2Int localMouseCoords, Integer mouseButton) {
        if (CommonGuiUtils.clickedBox(localMouseCoords.x(), localMouseCoords.y(), BUTTON_COORDS).booleanValue()) {
            Byte broadcastRange = MidiNbtDataUtils.getBroadcastRange(this.midiStack);
            broadcastRange = broadcastRange < MidiNbtDataUtils.MAX_BROADCAST_RANGE ? Byte.valueOf(Integer.valueOf(broadcastRange + 1).byteValue()) : MidiNbtDataUtils.MIN_BROADCAST_RANGE;
            MidiNbtDataUtils.setBroadcastRange(this.midiStack, broadcastRange);
            return true;
        }
        return false;
    }
}

