/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.client.gui.widget;

import io.github.tofodroid.mods.mimi.client.gui.CommonGuiUtils;
import io.github.tofodroid.mods.mimi.client.gui.widget.BaseWidget;
import io.github.tofodroid.mods.mimi.util.MidiNbtDataUtils;
import io.github.tofodroid.mods.mimi.util.Vector2Int;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.item.ItemStack;

public class AnalogModeWidget
extends BaseWidget {
    private static final Vector2Int BUTTON_COORDS = new Vector2Int(0, 0);
    private ItemStack midiStack;

    public AnalogModeWidget(ItemStack midiStack, Vector2Int screenOffset, Vector2Int start) {
        super("textures/gui/widget/analog_mode.png", 24, new Vector2Int(17, 17), screenOffset, start);
        this.midiStack = midiStack;
    }

    @Override
    public void renderGraphics(GuiGraphics graphics, Integer mouseX, Integer mouseY) {
        super.renderGraphics(graphics, mouseX, mouseY);
        if (MidiNbtDataUtils.getAnalogMode(this.midiStack).booleanValue()) {
            this.blitAbsolute(graphics, this.GUI_TEXTURE, this.ABSOLUTE_START.x() + 4, this.ABSOLUTE_START.y() + 5, 15.0f, 17.0f, 9, 7, this.TEXTURE_SIZE, this.TEXTURE_SIZE);
        }
    }

    @Override
    protected Boolean mouseClicked(Vector2Int localMouseCoords, Integer mouseButton) {
        if (CommonGuiUtils.clickedBox(localMouseCoords.x(), localMouseCoords.y(), BUTTON_COORDS).booleanValue()) {
            MidiNbtDataUtils.setAnalogMode(this.midiStack, MidiNbtDataUtils.getAnalogMode(this.midiStack) == false);
            return true;
        }
        return false;
    }
}

