/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.client.gui;

import io.github.tofodroid.mods.mimi.client.ClientProxy;
import io.github.tofodroid.mods.mimi.client.gui.CommonGuiUtils;
import io.github.tofodroid.mods.mimi.client.gui.GuiTransmitterBlock;
import io.github.tofodroid.mods.mimi.common.MIMIMod;
import io.github.tofodroid.mods.mimi.common.config.ConfigProxy;
import io.github.tofodroid.mods.mimi.common.midi.BasicMidiInfo;
import io.github.tofodroid.mods.mimi.common.network.ClientMidiListPacket;
import io.github.tofodroid.mods.mimi.common.network.NetworkProxy;
import io.github.tofodroid.mods.mimi.common.network.ServerMusicPlayerSongListPacket;
import io.github.tofodroid.mods.mimi.common.network.TransmitterControlPacket;
import io.github.tofodroid.mods.mimi.util.Vector2Int;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.CommonComponents;

public class GuiTransmitterItem
extends GuiTransmitterBlock {
    private static final Integer DEFAULT_TEXT_FIELD_COLOR = 0xE0E0E0;
    protected static final Vector2Int SYSTEM_MIDI_DEVICE_BUTTON = new Vector2Int(330, 7);
    protected static final Vector2Int SYSTEM_MIDI_DEVICE_LIGHT = new Vector2Int(349, 13);
    protected static final Vector2Int SOURCE_FILTER_BUTTON = new Vector2Int(265, 32);
    protected static final Vector2Int SOURCE_FILTER_SCREEN = new Vector2Int(283, 33);
    protected static final Vector2Int OPEN_LOCAL_FOLDER_BUTTON = new Vector2Int(10, 32);
    protected static final Vector2Int EDIT_LOCAL_FOLDER_BUTTON = new Vector2Int(28, 32);
    protected static final Vector2Int REFRESH_FOLDER_BUTTON = new Vector2Int(10, 32);
    private EditBox folderPathField;
    private Boolean editMode = false;
    private String folderPathString = ConfigProxy.getTransmitterMidiPath();

    public GuiTransmitterItem(UUID musicPlayerId) {
        super(musicPlayerId);
    }

    @Override
    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.f_96541_.f_91074_.m_6915_();
        }
        return !this.folderPathField.m_7933_(keyCode, scanCode, modifiers) && !this.folderPathField.m_94204_() ? super.m_7933_(keyCode, scanCode, modifiers) : true;
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.folderPathField = (EditBox)this.m_7787_((GuiEventListener)new EditBox(this.f_96547_, this.START_X + 45, this.START_Y + 32, 217, 15, CommonComponents.f_237098_));
        this.folderPathField.m_94144_(this.folderPathString);
        this.folderPathField.m_94199_(256);
        this.folderPathField.m_94151_(this::handlePathChange);
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        int imouseX = (int)Math.round(mouseX);
        int imouseY = (int)Math.round(mouseY);
        if (CommonGuiUtils.clickedBox(imouseX, imouseY, this.guiToScreenCoords(SYSTEM_MIDI_DEVICE_BUTTON)).booleanValue()) {
            ((ClientProxy)MIMIMod.getProxy()).getMidiData().inputDeviceManager.toggleTransmitMidiInput();
        } else if (CommonGuiUtils.clickedBox(imouseX, imouseY, this.guiToScreenCoords(SOURCE_FILTER_BUTTON)).booleanValue()) {
            this.sendTransmitterCommand(TransmitterControlPacket.CONTROL.SOURCE_M);
        } else if (!this.editMode.booleanValue()) {
            if (CommonGuiUtils.clickedBox(imouseX, imouseY, this.guiToScreenCoords(OPEN_LOCAL_FOLDER_BUTTON)).booleanValue()) {
                Util.m_137581_().m_137648_(Path.of(MIMIMod.getProxy().clientMidiFiles().getCurrentFolderPath(), new String[0]).toUri());
            } else if (CommonGuiUtils.clickedBox(imouseX, imouseY, this.guiToScreenCoords(EDIT_LOCAL_FOLDER_BUTTON)).booleanValue()) {
                this.editMode = true;
            }
        } else if (CommonGuiUtils.clickedBox(imouseX, imouseY, this.guiToScreenCoords(OPEN_LOCAL_FOLDER_BUTTON)).booleanValue()) {
            this.folderPathString = ConfigProxy.getTransmitterMidiPath();
            this.editMode = false;
        } else if (CommonGuiUtils.clickedBox(imouseX, imouseY, this.guiToScreenCoords(EDIT_LOCAL_FOLDER_BUTTON)).booleanValue()) {
            if (this.folderPathString != null) {
                ConfigProxy.setTransmitterMidiPath(this.folderPathString);
                MIMIMod.getProxy().clientMidiFiles().setDirectory(this.folderPathString);
                MIMIMod.getProxy().clientMidiFiles().loadSongs();
                NetworkProxy.sendToServer(new ClientMidiListPacket(MIMIMod.getProxy().clientMidiFiles().getSortedSongInfos()));
            } else {
                ConfigProxy.setTransmitterMidiPath("");
                MIMIMod.getProxy().clientMidiFiles().init();
                MIMIMod.getProxy().clientMidiFiles().loadSongs();
                NetworkProxy.sendToServer(new ClientMidiListPacket(MIMIMod.getProxy().clientMidiFiles().getSortedSongInfos()));
            }
            this.editMode = false;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    @Override
    protected GuiGraphics renderGraphics(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderGraphics(graphics, mouseX, mouseY, partialTicks);
        this.blitAbsolute(graphics, this.guiTexture, this.START_X + 240, this.START_Y + 4, 1.0f, 327.0f, 116, 21, this.TEXTURE_SIZE, this.TEXTURE_SIZE);
        if (((ClientProxy)MIMIMod.getProxy()).getMidiData().inputDeviceManager.getTransmitMidiInput().booleanValue()) {
            this.blitAbsolute(graphics, this.guiTexture, this.START_X + SYSTEM_MIDI_DEVICE_LIGHT.x(), this.START_Y + SYSTEM_MIDI_DEVICE_LIGHT.y(), 1.0f, 349.0f, 3, 3, this.TEXTURE_SIZE, this.TEXTURE_SIZE);
        }
        if (!this.editMode.booleanValue()) {
            this.blitAbsolute(graphics, this.guiTexture, this.START_X + 9, this.START_Y + 31, 173.0f, 269.0f, 17, 17, this.TEXTURE_SIZE, this.TEXTURE_SIZE);
            this.blitAbsolute(graphics, this.guiTexture, this.START_X + 27, this.START_Y + 31, 225.0f, 269.0f, 17, 17, this.TEXTURE_SIZE, this.TEXTURE_SIZE);
        } else {
            this.blitAbsolute(graphics, this.guiTexture, this.START_X + 9, this.START_Y + 31, 243.0f, 269.0f, 17, 17, this.TEXTURE_SIZE, this.TEXTURE_SIZE);
            this.blitAbsolute(graphics, this.guiTexture, this.START_X + 27, this.START_Y + 31, 261.0f, 269.0f, 17, 17, this.TEXTURE_SIZE, this.TEXTURE_SIZE);
            this.folderPathField.m_88315_(graphics, mouseX, mouseY, partialTicks);
        }
        this.blitAbsolute(graphics, this.guiTexture, this.START_X + 264, this.START_Y + 31, 191.0f, 269.0f, 33, 17, this.TEXTURE_SIZE, this.TEXTURE_SIZE);
        this.blitAbsolute(graphics, this.guiTexture, this.START_X + 283, this.START_Y + 33, 105 + this.musicStatus.sourceMode.ordinal() * 13, 269.0f, 13, 13, this.TEXTURE_SIZE, this.TEXTURE_SIZE);
        return graphics;
    }

    @Override
    protected Integer maxPlaylistSongTitleWidth() {
        return 318;
    }

    @Override
    public Boolean isSinglePlayerOrLANHost() {
        return false;
    }

    @Override
    protected GuiGraphics renderPlaylistSongBadges(GuiGraphics graphics, BasicMidiInfo info, Integer songIndex, Integer minSong) {
        super.renderPlaylistSongBadges(graphics, info, songIndex, minSong);
        this.blitAbsolute(graphics, this.guiTexture, this.START_X + 329, this.START_Y + this.getFirstSongY() - 1 + songIndex * 11, info.serverMidi == false ? 163.0f : 154.0f, 269.0f, 9, 9, this.TEXTURE_SIZE, this.TEXTURE_SIZE);
        return graphics;
    }

    @Override
    protected void startRefreshSongList() {
        NetworkProxy.sendToServer(new ClientMidiListPacket(MIMIMod.getProxy().clientMidiFiles().getSortedSongInfos()));
        NetworkProxy.sendToServer(new ServerMusicPlayerSongListPacket(this.musicPlayerId));
    }

    @Override
    protected void onRefreshClick() {
        MIMIMod.getProxy().clientMidiFiles().loadSongs();
        this.startRefreshSongList();
    }

    protected void handlePathChange(String folderPath) {
        if (folderPath != null && !folderPath.trim().isEmpty()) {
            try {
                if (!Files.isDirectory(Paths.get(folderPath, new String[0]), LinkOption.NOFOLLOW_LINKS)) {
                    throw new RuntimeException("Folder not found: " + folderPath);
                }
                this.folderPathString = folderPath.trim();
                this.folderPathField.m_94202_(DEFAULT_TEXT_FIELD_COLOR.intValue());
            }
            catch (Exception e) {
                this.folderPathString = null;
                this.folderPathField.m_94202_(13112340);
            }
        } else {
            this.folderPathString = null;
            this.folderPathField.m_94202_(13112340);
        }
    }
}

