/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.client.gui;

import io.github.tofodroid.mods.mimi.client.gui.BaseGui;
import io.github.tofodroid.mods.mimi.client.gui.CommonGuiUtils;
import io.github.tofodroid.mods.mimi.client.gui.widget.BroadcastRangeWidget;
import io.github.tofodroid.mods.mimi.client.gui.widget.TransmitterSourceWidget;
import io.github.tofodroid.mods.mimi.common.MIMIMod;
import io.github.tofodroid.mods.mimi.common.network.ConfigurableMidiTileSyncPacket;
import io.github.tofodroid.mods.mimi.common.network.NetworkProxy;
import io.github.tofodroid.mods.mimi.util.ByteUtils;
import io.github.tofodroid.mods.mimi.util.MidiNbtDataUtils;
import io.github.tofodroid.mods.mimi.util.Vector2Int;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class GuiRelay
extends BaseGui {
    private static final Vector2Int TRANSMIT_SOURCE_WIDGET_COORDS = new Vector2Int(178, 29);
    private static final Vector2Int RANGE_WIDGET_COORDS = new Vector2Int(279, 6);
    private static final Vector2Int ALL_CHANNELS_BUTTON_COORDS = new Vector2Int(110, 58);
    private static final Vector2Int CLEAR_CHANNELS_BUTTON_COORDS = new Vector2Int(131, 58);
    private static final Vector2Int RESET_CHANNELS_BUTTON_COORDS = new Vector2Int(152, 58);
    private static final Vector2Int CHANNEL_ONE_BUTTON_COORDS = new Vector2Int(9, 58);
    private static final Vector2Int CHANNEL_ONE_LIGHT_COORDS = new Vector2Int(28, 64);
    private static final Vector2Int CHANNEL_ONE_SCREEN_COORDS = new Vector2Int(69, 62);
    private static final Vector2Int CHANNEL_ONE_DOWN_COORDS = new Vector2Int(50, 58);
    private static final Vector2Int CHANNEL_ONE_UP_COORDS = new Vector2Int(84, 58);
    private static final Vector2Int CHANNEL_TWO_BUTTON_COORDS = new Vector2Int(9, 77);
    private static final Vector2Int CHANNEL_TWO_LIGHT_COORDS = new Vector2Int(28, 83);
    private static final Vector2Int CHANNEL_TWO_SCREEN_COORDS = new Vector2Int(69, 81);
    private static final Vector2Int CHANNEL_TWO_DOWN_COORDS = new Vector2Int(50, 77);
    private static final Vector2Int CHANNEL_TWO_UP_COORDS = new Vector2Int(84, 77);
    private static final Vector2Int CHANNEL_ROW_COL_OFFSET = new Vector2Int(96, 19);
    private TransmitterSourceWidget transmitSource;
    private BroadcastRangeWidget broadcastRange;
    private final Player player;
    private final ItemStack relayStack;
    private final BlockPos tilePos;
    private final InteractionHand handIn;

    public GuiRelay(Player player, BlockPos tilePos, InteractionHand handIn, ItemStack relayStack) {
        super(300, 177, 300, "textures/gui/container_relay.png", "item.MIMIMod.gui_relay");
        this.player = player;
        this.tilePos = tilePos;
        this.handIn = handIn;
        if (relayStack == null || relayStack.m_41619_()) {
            MIMIMod.LOGGER.error("Relay stack is null or empty. Force closing GUI!");
            Minecraft.m_91087_().m_91346_((Screen)null);
            this.relayStack = null;
            return;
        }
        this.relayStack = new ItemStack((ItemLike)relayStack.m_41720_(), relayStack.m_41613_());
        this.relayStack.m_41751_(relayStack.m_41784_().m_6426_());
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.transmitSource = new TransmitterSourceWidget(this.relayStack, this.player.m_20148_(), this.player.m_7755_().getString(), new Vector2Int(this.START_X, this.START_Y), TRANSMIT_SOURCE_WIDGET_COORDS);
        this.broadcastRange = new BroadcastRangeWidget(this.relayStack, new Vector2Int(this.START_X, this.START_Y), RANGE_WIDGET_COORDS);
    }

    public void syncRelayToServer() {
        NetworkProxy.sendToServer(new ConfigurableMidiTileSyncPacket(this.relayStack, this.tilePos, this.handIn));
    }

    public Byte channelButtonClicked(int imouseX, int imouseY, Vector2Int channelOne, Vector2Int channelTwo) {
        if (CommonGuiUtils.clickedBox(imouseX, imouseY, this.guiToScreenCoords(channelOne)).booleanValue()) {
            return (byte)0;
        }
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 5; ++y) {
                if (!CommonGuiUtils.clickedBox(imouseX, imouseY, this.guiToScreenCoords(new Vector2Int(channelTwo.x + x * GuiRelay.CHANNEL_ROW_COL_OFFSET.x, channelTwo.y + y * GuiRelay.CHANNEL_ROW_COL_OFFSET.y))).booleanValue()) continue;
                return Integer.valueOf(1 + x * 5 + y).byteValue();
            }
        }
        return null;
    }

    public boolean m_6375_(double dmouseX, double dmouseY, int mouseButton) {
        int imouseX = (int)Math.round(dmouseX);
        int imouseY = (int)Math.round(dmouseY);
        if (this.transmitSource.mouseClicked(imouseX, imouseY, mouseButton).booleanValue()) {
            this.syncRelayToServer();
        } else if (this.broadcastRange.mouseClicked(imouseX, imouseY, mouseButton).booleanValue()) {
            this.syncRelayToServer();
        } else if (CommonGuiUtils.clickedBox(imouseX, imouseY, this.guiToScreenCoords(ALL_CHANNELS_BUTTON_COORDS)).booleanValue()) {
            MidiNbtDataUtils.setEnableAllChannels(this.relayStack);
            this.syncRelayToServer();
        } else if (CommonGuiUtils.clickedBox(imouseX, imouseY, this.guiToScreenCoords(CLEAR_CHANNELS_BUTTON_COORDS)).booleanValue()) {
            MidiNbtDataUtils.clearEnabledChannels(this.relayStack);
            this.syncRelayToServer();
        } else if (CommonGuiUtils.clickedBox(imouseX, imouseY, this.guiToScreenCoords(RESET_CHANNELS_BUTTON_COORDS)).booleanValue()) {
            MidiNbtDataUtils.setChannelMap(this.relayStack, new Byte[]{(byte)0, (byte)1, (byte)2, (byte)3, (byte)4, (byte)5, (byte)6, (byte)7, (byte)8, (byte)9, (byte)10, (byte)11, (byte)12, (byte)13, (byte)14, (byte)15});
            this.syncRelayToServer();
        } else {
            Byte clickedChannel = this.channelButtonClicked(imouseX, imouseY, CHANNEL_ONE_BUTTON_COORDS, CHANNEL_TWO_BUTTON_COORDS);
            if (clickedChannel != null) {
                MidiNbtDataUtils.toggleChannel(this.relayStack, clickedChannel);
                this.syncRelayToServer();
            }
            if ((clickedChannel = this.channelButtonClicked(imouseX, imouseY, CHANNEL_ONE_DOWN_COORDS, CHANNEL_TWO_DOWN_COORDS)) != null) {
                MidiNbtDataUtils.setChannelMap(this.relayStack, clickedChannel, Integer.valueOf(MidiNbtDataUtils.getChannelMap(this.relayStack, clickedChannel) - 1).byteValue());
                this.syncRelayToServer();
            }
            if ((clickedChannel = this.channelButtonClicked(imouseX, imouseY, CHANNEL_ONE_UP_COORDS, CHANNEL_TWO_UP_COORDS)) != null) {
                MidiNbtDataUtils.setChannelMap(this.relayStack, clickedChannel, Integer.valueOf(MidiNbtDataUtils.getChannelMap(this.relayStack, clickedChannel) + 1).byteValue());
                this.syncRelayToServer();
            }
        }
        return super.m_6375_(dmouseX, dmouseY, mouseButton);
    }

    @Override
    protected GuiGraphics renderGraphics(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.blitRelative(graphics, 0, 0, 0.0f, 0.0f, this.GUI_WIDTH, this.GUI_HEIGHT);
        this.transmitSource.renderGraphics(graphics, mouseX, mouseY);
        this.broadcastRange.renderGraphics(graphics, mouseX, mouseY);
        if (MidiNbtDataUtils.isChannelEnabled(this.relayStack, ByteUtils.ZERO).booleanValue()) {
            this.blitRelative(graphics, GuiRelay.CHANNEL_ONE_LIGHT_COORDS.x, GuiRelay.CHANNEL_ONE_LIGHT_COORDS.y, 0.0f, 177.0f, 3, 3);
        }
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 5; ++y) {
                if (!MidiNbtDataUtils.isChannelEnabled(this.relayStack, (Byte)Integer.valueOf(1 + x * 5 + y).byteValue()).booleanValue()) continue;
                this.blitRelative(graphics, GuiRelay.CHANNEL_TWO_LIGHT_COORDS.x + x * GuiRelay.CHANNEL_ROW_COL_OFFSET.x, GuiRelay.CHANNEL_TWO_LIGHT_COORDS.y + y * GuiRelay.CHANNEL_ROW_COL_OFFSET.y, 0.0f, 177.0f, 3, 3);
            }
        }
        return graphics;
    }

    @Override
    protected GuiGraphics renderText(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.transmitSource.renderText(graphics, this.f_96547_, mouseX, mouseY);
        this.broadcastRange.renderText(graphics, this.f_96547_, mouseX, mouseY);
        Integer mapValue = MidiNbtDataUtils.getChannelMap(this.relayStack, ByteUtils.ZERO) + 1;
        this.drawStringRelative(graphics, (String)(mapValue < 10 ? "0" + mapValue : mapValue.toString()), GuiRelay.CHANNEL_ONE_SCREEN_COORDS.x, GuiRelay.CHANNEL_ONE_SCREEN_COORDS.y, -16718336);
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 5; ++y) {
                mapValue = MidiNbtDataUtils.getChannelMap(this.relayStack, Integer.valueOf(1 + x * 5 + y).byteValue()) + 1;
                this.drawStringRelative(graphics, (String)(mapValue < 10 ? "0" + mapValue : mapValue.toString()), GuiRelay.CHANNEL_TWO_SCREEN_COORDS.x + x * GuiRelay.CHANNEL_ROW_COL_OFFSET.x, GuiRelay.CHANNEL_TWO_SCREEN_COORDS.y + y * GuiRelay.CHANNEL_ROW_COL_OFFSET.y, -16718336);
            }
        }
        return graphics;
    }
}

