/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.com.sun.media.sound;

import io.github.tofodroid.com.sun.media.sound.RIFFReader;
import io.github.tofodroid.com.sun.media.sound.StandardFileFormat;
import io.github.tofodroid.com.sun.media.sound.SunFileReader;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;

public final class WaveFloatFileReader
extends SunFileReader {
    @Override
    StandardFileFormat getAudioFileFormatImpl(InputStream stream) throws UnsupportedAudioFileException, IOException {
        RIFFReader riffiterator = new RIFFReader(stream);
        if (!riffiterator.getFormat().equals("RIFF")) {
            throw new UnsupportedAudioFileException();
        }
        if (!riffiterator.getType().equals("WAVE")) {
            throw new UnsupportedAudioFileException();
        }
        boolean fmt_found = false;
        boolean data_found = false;
        int channels = 1;
        long samplerate = 1L;
        int framesize = 1;
        int bits = 1;
        long dataSize = 0L;
        while (riffiterator.hasNextChunk()) {
            RIFFReader chunk = riffiterator.nextChunk();
            if (chunk.getFormat().equals("fmt ")) {
                fmt_found = true;
                int format = chunk.readUnsignedShort();
                if (format != 3) {
                    throw new UnsupportedAudioFileException();
                }
                channels = chunk.readUnsignedShort();
                samplerate = chunk.readUnsignedInt();
                chunk.readUnsignedInt();
                framesize = chunk.readUnsignedShort();
                bits = chunk.readUnsignedShort();
            }
            if (!chunk.getFormat().equals("data")) continue;
            dataSize = chunk.getSize();
            data_found = true;
            break;
        }
        if (!fmt_found || !data_found) {
            throw new UnsupportedAudioFileException();
        }
        AudioFormat audioformat = new AudioFormat(AudioFormat.Encoding.PCM_FLOAT, samplerate, bits, channels, framesize, samplerate, false);
        return new StandardFileFormat(AudioFileFormat.Type.WAVE, audioformat, dataSize / (long)audioformat.getFrameSize());
    }

    @Override
    public AudioInputStream getAudioInputStream(InputStream stream) throws UnsupportedAudioFileException, IOException {
        StandardFileFormat format = this.getAudioFileFormat(stream);
        AudioFormat af = format.getFormat();
        long length = format.getLongFrameLength();
        RIFFReader riffiterator = new RIFFReader(stream);
        while (riffiterator.hasNextChunk()) {
            RIFFReader chunk = riffiterator.nextChunk();
            if (!chunk.getFormat().equals("data")) continue;
            return new AudioInputStream(chunk, af, length);
        }
        throw new UnsupportedAudioFileException();
    }
}

