/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.com.sun.media.sound;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.SysexMessage;

public class UniversalSysExBuilder {
    public static final int ALL_DEVICES = 127;
    private static final byte[] UNIVERSAL_NON_REALTIME_SYSEX_HEADER = new byte[]{-16, 126};
    private static final byte[] UNIVERSAL_REALTIME_SYSEX_HEADER = new byte[]{-16, 127};
    private static final byte[] EOX = new byte[]{-9};

    public static class MidiTuningStandard {
        public static final int TUNING_A440 = 737280;
        public static final int TUNING_NO_CHANGE = 0x1FFFFF;
        private static final byte[] MIDI_TUNING_STANDARD = new byte[]{8};
        private static final byte[] BULK_TUNING_DUMP = new byte[]{1};
        private static final byte[] SINGLE_NOTE_TUNING_CHANGE = new byte[]{2};
        private static final byte[] KEY_BASED_TUNING_DUMP = new byte[]{4};
        private static final byte[] SCALE_OCTAVE_TUNING_DUMP_1BYTE_FORM = new byte[]{5};
        private static final byte[] SCALE_OCTAVE_TUNING_DUMP_2BYTE_FORM = new byte[]{6};
        private static final byte[] SINGLE_NOTE_TUNING_CHANGE_BANK = new byte[]{7};
        private static final byte[] SCALE_OCTAVE_TUNING_1BYTE_FORM = new byte[]{8};
        private static final byte[] SCALE_OCTAVE_TUNING_2BYTE_FORM = new byte[]{9};

        public static SysexMessage scaleOctaveTuning1ByteForm(int targetDevice, boolean realtime, boolean[] channels, int[] tuning) throws IOException, InvalidMidiDataException {
            int i;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            if (realtime) {
                baos.write(UNIVERSAL_REALTIME_SYSEX_HEADER);
            } else {
                baos.write(UNIVERSAL_NON_REALTIME_SYSEX_HEADER);
            }
            baos.write((byte)targetDevice);
            baos.write(MIDI_TUNING_STANDARD);
            baos.write(SCALE_OCTAVE_TUNING_1BYTE_FORM);
            int channelmask = 0;
            for (i = 0; i < 2; ++i) {
                if (!channels[i + 14]) continue;
                channelmask += 1 << i;
            }
            baos.write((byte)channelmask);
            channelmask = 0;
            for (i = 0; i < 7; ++i) {
                if (!channels[i + 7]) continue;
                channelmask += 1 << i;
            }
            baos.write((byte)channelmask);
            channelmask = 0;
            for (i = 0; i < 7; ++i) {
                if (!channels[i]) continue;
                channelmask += 1 << i;
            }
            baos.write((byte)channelmask);
            for (i = 0; i < 12; ++i) {
                baos.write((byte)(tuning[i] + 64));
            }
            baos.write(EOX);
            SysexMessage sysex = new SysexMessage();
            byte[] data = baos.toByteArray();
            sysex.setMessage(data, data.length);
            return sysex;
        }

        public static SysexMessage scaleOctaveTuning2ByteForm(int targetDevice, boolean realtime, boolean[] channels, int[] tuning) throws IOException, InvalidMidiDataException {
            int i;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            if (realtime) {
                baos.write(UNIVERSAL_REALTIME_SYSEX_HEADER);
            } else {
                baos.write(UNIVERSAL_NON_REALTIME_SYSEX_HEADER);
            }
            baos.write((byte)targetDevice);
            baos.write(MIDI_TUNING_STANDARD);
            baos.write(SCALE_OCTAVE_TUNING_2BYTE_FORM);
            int channelmask = 0;
            for (i = 0; i < 2; ++i) {
                if (!channels[i + 14]) continue;
                channelmask += 1 << i;
            }
            baos.write((byte)channelmask);
            channelmask = 0;
            for (i = 0; i < 7; ++i) {
                if (!channels[i + 7]) continue;
                channelmask += 1 << i;
            }
            baos.write((byte)channelmask);
            channelmask = 0;
            for (i = 0; i < 7; ++i) {
                if (!channels[i]) continue;
                channelmask += 1 << i;
            }
            baos.write((byte)channelmask);
            for (i = 0; i < 12; ++i) {
                int t = tuning[i] + 8192;
                baos.write((byte)(t / 128));
                baos.write((byte)(t % 128));
            }
            baos.write(EOX);
            SysexMessage sysex = new SysexMessage();
            byte[] data = baos.toByteArray();
            sysex.setMessage(data, data.length);
            return sysex;
        }

        private static void setTuningChecksum(byte[] data) {
            int x = data[1] & 0xFF;
            for (int i = 2; i < data.length - 2; ++i) {
                x ^= data[i] & 0xFF;
            }
            data[data.length - 2] = (byte)(x & 0x7F);
        }

        public static SysexMessage scaleOctaveTuningDump1ByteForm(int targetDevice, int bank, int preset, String name, int[] tuning) throws IOException, InvalidMidiDataException {
            int i;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(UNIVERSAL_NON_REALTIME_SYSEX_HEADER);
            baos.write((byte)targetDevice);
            baos.write(MIDI_TUNING_STANDARD);
            baos.write(SCALE_OCTAVE_TUNING_DUMP_1BYTE_FORM);
            baos.write((byte)bank);
            baos.write((byte)preset);
            if (name.length() > 16) {
                name = name.substring(0, 16);
            }
            byte[] namebytes = name.getBytes("ASCII");
            baos.write(namebytes);
            byte space_char = " ".getBytes()[0];
            for (i = namebytes.length; i < 16; ++i) {
                baos.write(space_char);
            }
            for (i = 0; i < 12; ++i) {
                baos.write((byte)(tuning[i] + 64));
            }
            baos.write(0);
            baos.write(EOX);
            SysexMessage sysex = new SysexMessage();
            byte[] data = baos.toByteArray();
            MidiTuningStandard.setTuningChecksum(data);
            sysex.setMessage(data, data.length);
            return sysex;
        }

        public static SysexMessage scaleOctaveTuningDump2ByteForm(int targetDevice, int bank, int preset, String name, int[] tuning) throws IOException, InvalidMidiDataException {
            int i;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(UNIVERSAL_NON_REALTIME_SYSEX_HEADER);
            baos.write((byte)targetDevice);
            baos.write(MIDI_TUNING_STANDARD);
            baos.write(SCALE_OCTAVE_TUNING_DUMP_2BYTE_FORM);
            baos.write((byte)bank);
            baos.write((byte)preset);
            if (name.length() > 16) {
                name = name.substring(0, 16);
            }
            byte[] namebytes = name.getBytes("ASCII");
            baos.write(namebytes);
            byte space_char = " ".getBytes()[0];
            for (i = namebytes.length; i < 16; ++i) {
                baos.write(space_char);
            }
            for (i = 0; i < 12; ++i) {
                int t = tuning[i] + 8192;
                baos.write((byte)(t / 128));
                baos.write((byte)(t % 128));
            }
            baos.write(0);
            baos.write(EOX);
            SysexMessage sysex = new SysexMessage();
            byte[] data = baos.toByteArray();
            MidiTuningStandard.setTuningChecksum(data);
            sysex.setMessage(data, data.length);
            return sysex;
        }

        public static SysexMessage singleNoteTuningChange(int targetDevice, boolean realtime, int bank, int preset, int[] key_numbers, int[] key_tunings) throws IOException, InvalidMidiDataException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            if (realtime) {
                baos.write(UNIVERSAL_REALTIME_SYSEX_HEADER);
            } else {
                baos.write(UNIVERSAL_NON_REALTIME_SYSEX_HEADER);
            }
            baos.write((byte)targetDevice);
            baos.write(MIDI_TUNING_STANDARD);
            baos.write(SINGLE_NOTE_TUNING_CHANGE_BANK);
            baos.write((byte)bank);
            baos.write((byte)preset);
            baos.write((byte)key_numbers.length);
            for (int i = 0; i < key_numbers.length; ++i) {
                baos.write((byte)key_numbers[i]);
                int t = key_tunings[i];
                baos.write((byte)(t / 16384 % 128));
                baos.write((byte)(t / 128 % 128));
                baos.write((byte)(t % 128));
            }
            baos.write(EOX);
            SysexMessage sysex = new SysexMessage();
            byte[] data = baos.toByteArray();
            sysex.setMessage(data, data.length);
            return sysex;
        }

        public static SysexMessage singleNoteTuningChange(int targetDevice, int preset, int[] key_numbers, int[] key_tunings) throws IOException, InvalidMidiDataException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(UNIVERSAL_REALTIME_SYSEX_HEADER);
            baos.write((byte)targetDevice);
            baos.write(MIDI_TUNING_STANDARD);
            baos.write(SINGLE_NOTE_TUNING_CHANGE);
            baos.write((byte)preset);
            baos.write((byte)key_numbers.length);
            for (int i = 0; i < key_numbers.length; ++i) {
                baos.write((byte)key_numbers[i]);
                int t = key_tunings[i];
                baos.write((byte)(t / 16384 % 128));
                baos.write((byte)(t / 128 % 128));
                baos.write((byte)(t % 128));
            }
            baos.write(EOX);
            SysexMessage sysex = new SysexMessage();
            byte[] data = baos.toByteArray();
            sysex.setMessage(data, data.length);
            return sysex;
        }

        public static SysexMessage keyBasedTuningDump(int targetDevice, int preset, String name, int[] tunings) throws IOException, InvalidMidiDataException {
            int i;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(UNIVERSAL_NON_REALTIME_SYSEX_HEADER);
            baos.write((byte)targetDevice);
            baos.write(MIDI_TUNING_STANDARD);
            baos.write(BULK_TUNING_DUMP);
            baos.write((byte)preset);
            if (name.length() > 16) {
                name = name.substring(0, 16);
            }
            byte[] namebytes = name.getBytes("ASCII");
            baos.write(namebytes);
            byte space_char = " ".getBytes()[0];
            for (i = namebytes.length; i < 16; ++i) {
                baos.write(space_char);
            }
            for (i = 0; i < 128; ++i) {
                int t = tunings[i];
                baos.write((byte)(t / 16384 % 128));
                baos.write((byte)(t / 128 % 128));
                baos.write((byte)(t % 128));
            }
            baos.write(0);
            baos.write(EOX);
            SysexMessage sysex = new SysexMessage();
            byte[] data = baos.toByteArray();
            MidiTuningStandard.setTuningChecksum(data);
            sysex.setMessage(data, data.length);
            return sysex;
        }

        public static SysexMessage keyBasedTuningDump(int targetDevice, int bank, int preset, String name, int[] tunings) throws IOException, InvalidMidiDataException {
            int i;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(UNIVERSAL_NON_REALTIME_SYSEX_HEADER);
            baos.write((byte)targetDevice);
            baos.write(MIDI_TUNING_STANDARD);
            baos.write(KEY_BASED_TUNING_DUMP);
            baos.write((byte)bank);
            baos.write((byte)preset);
            if (name.length() > 16) {
                name = name.substring(0, 16);
            }
            byte[] namebytes = name.getBytes("ASCII");
            baos.write(namebytes);
            byte space_char = " ".getBytes()[0];
            for (i = namebytes.length; i < 16; ++i) {
                baos.write(space_char);
            }
            for (i = 0; i < 128; ++i) {
                int t = tunings[i];
                baos.write((byte)(t / 16384 % 128));
                baos.write((byte)(t / 128 % 128));
                baos.write((byte)(t % 128));
            }
            baos.write(0);
            baos.write(EOX);
            SysexMessage sysex = new SysexMessage();
            byte[] data = baos.toByteArray();
            MidiTuningStandard.setTuningChecksum(data);
            sysex.setMessage(data, data.length);
            return sysex;
        }
    }

    public static class DestinationSettings {
        private static final byte[] CONTROLLER_DESTINATION_SETTINGS = new byte[]{9};
        private static final byte[] CONTROLLER_CHANNEL_PRESSURE = new byte[]{1};
        private static final byte[] CONTROLLER_POLY_PRESSURE = new byte[]{2};
        private static final byte[] CONTROLLER_CONTROL_CHANGE = new byte[]{3};

        public static SysexMessage setControllerDestinationForChannelPressure(int targetDevice, int channel, int[] controls, int[] ranges) throws IOException, InvalidMidiDataException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(UNIVERSAL_REALTIME_SYSEX_HEADER);
            baos.write((byte)targetDevice);
            baos.write(CONTROLLER_DESTINATION_SETTINGS);
            baos.write(CONTROLLER_CHANNEL_PRESSURE);
            baos.write((byte)channel);
            for (int i = 0; i < controls.length; ++i) {
                baos.write((byte)controls[i]);
                baos.write((byte)ranges[i]);
            }
            baos.write(EOX);
            SysexMessage sysex = new SysexMessage();
            byte[] data = baos.toByteArray();
            sysex.setMessage(data, data.length);
            return sysex;
        }

        public static SysexMessage setControllerDestinationForPolyPressure(int targetDevice, int channel, int[] controls, int[] ranges) throws IOException, InvalidMidiDataException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(UNIVERSAL_REALTIME_SYSEX_HEADER);
            baos.write((byte)targetDevice);
            baos.write(CONTROLLER_DESTINATION_SETTINGS);
            baos.write(CONTROLLER_POLY_PRESSURE);
            baos.write((byte)channel);
            for (int i = 0; i < controls.length; ++i) {
                baos.write((byte)controls[i]);
                baos.write((byte)ranges[i]);
            }
            baos.write(EOX);
            SysexMessage sysex = new SysexMessage();
            byte[] data = baos.toByteArray();
            sysex.setMessage(data, data.length);
            return sysex;
        }

        public static SysexMessage setControllerDestinationForControlChange(int targetDevice, int channel, byte control, int[] controls, int[] ranges) throws IOException, InvalidMidiDataException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(UNIVERSAL_REALTIME_SYSEX_HEADER);
            baos.write((byte)targetDevice);
            baos.write(CONTROLLER_DESTINATION_SETTINGS);
            baos.write(CONTROLLER_CONTROL_CHANGE);
            baos.write((byte)channel);
            baos.write(control);
            for (int i = 0; i < controls.length; ++i) {
                baos.write((byte)controls[i]);
                baos.write((byte)ranges[i]);
            }
            baos.write(EOX);
            SysexMessage sysex = new SysexMessage();
            byte[] data = baos.toByteArray();
            sysex.setMessage(data, data.length);
            return sysex;
        }
    }

    public static class KeyBasedInstrumentControl {
        public static final int KEY_BASED_CONTORL_FINE_TUNING = 120;
        public static final int KEY_BASED_CONTORL_COARSE_TUNING = 121;
        private static final byte[] KEY_BASED_INSTRUMENT_CONTROL = new byte[]{10};
        private static final byte[] BASIC_MESSAGE = new byte[]{1};

        public static SysexMessage setKeyBasedControl(int targetDevice, int midi_channel, int key_number, int control, int value) throws IOException, InvalidMidiDataException {
            return KeyBasedInstrumentControl.setKeyBasedControl(targetDevice, midi_channel, key_number, new int[]{control}, new int[]{value});
        }

        public static SysexMessage setKeyBasedControl(int targetDevice, int midi_channel, int key_number, int[] controls, int[] values) throws IOException, InvalidMidiDataException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(UNIVERSAL_REALTIME_SYSEX_HEADER);
            baos.write((byte)targetDevice);
            baos.write(KEY_BASED_INSTRUMENT_CONTROL);
            baos.write(BASIC_MESSAGE);
            baos.write((byte)midi_channel);
            baos.write((byte)key_number);
            for (int i = 0; i < controls.length; ++i) {
                baos.write((byte)controls[i]);
                baos.write((byte)values[i]);
            }
            baos.write(EOX);
            SysexMessage sysex = new SysexMessage();
            byte[] data = baos.toByteArray();
            sysex.setMessage(data, data.length);
            return sysex;
        }
    }

    public static class DeviceControl {
        private static final byte[] DEVICE_CONTROL = new byte[]{4};
        private static final byte MASTER_VOLUME = 1;
        private static final byte MASTER_BALANCE = 2;
        private static final byte MASTER_FINE_TUNING = 3;
        private static final byte MASTER_COARSE_TUNING = 4;
        private static final byte[] GLOBAL_PARAMETER_CONTROL = new byte[]{5};

        private static SysexMessage setDeviceControl(int targetDevice, int control, int value) throws IOException, InvalidMidiDataException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(UNIVERSAL_REALTIME_SYSEX_HEADER);
            baos.write((byte)targetDevice);
            baos.write(DEVICE_CONTROL);
            baos.write((byte)control);
            baos.write((byte)(value % 128));
            baos.write((byte)(value / 128));
            baos.write(EOX);
            SysexMessage sysex = new SysexMessage();
            byte[] data = baos.toByteArray();
            sysex.setMessage(data, data.length);
            return sysex;
        }

        public static SysexMessage setMasterVolume(int targetDevice, int value) throws IOException, InvalidMidiDataException {
            return DeviceControl.setDeviceControl(targetDevice, 1, value);
        }

        public static SysexMessage setMasterBalance(int targetDevice, int value) throws IOException, InvalidMidiDataException {
            return DeviceControl.setDeviceControl(targetDevice, 2, value);
        }

        public static SysexMessage setMasterFineTuning(int targetDevice, int value) throws IOException, InvalidMidiDataException {
            return DeviceControl.setDeviceControl(targetDevice, 3, value);
        }

        public static SysexMessage setMasterCoarseTuning(int targetDevice, int value) throws IOException, InvalidMidiDataException {
            return DeviceControl.setDeviceControl(targetDevice, 4, value);
        }

        public static SysexMessage setGlobalParameter(int targetDevice, short[] slotpath, byte[] parameter, int value) throws IOException, InvalidMidiDataException {
            return DeviceControl.setGlobalParameter(targetDevice, slotpath, parameter, new byte[]{(byte)value});
        }

        public static SysexMessage setGlobalParameter(int targetDevice, short[] slotpath, byte[] parameter, byte[] value) throws IOException, InvalidMidiDataException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(UNIVERSAL_REALTIME_SYSEX_HEADER);
            baos.write((byte)targetDevice);
            baos.write(DEVICE_CONTROL);
            baos.write(GLOBAL_PARAMETER_CONTROL);
            baos.write((byte)slotpath.length);
            baos.write((byte)parameter.length);
            baos.write((byte)value.length);
            for (int i = 0; i < slotpath.length; ++i) {
                short x = slotpath[0];
                baos.write((byte)(x >>> 8));
                baos.write((byte)x);
            }
            baos.write(parameter);
            baos.write(value);
            baos.write(EOX);
            SysexMessage sysex = new SysexMessage();
            byte[] data = baos.toByteArray();
            sysex.setMessage(data, data.length);
            return sysex;
        }

        public static class ChorusEffect {
            public static final int CHORUS_TYPE_CHORUS1 = 0;
            public static final int CHORUS_TYPE_CHORUS2 = 1;
            public static final int CHORUS_TYPE_CHORUS3 = 2;
            public static final int CHORUS_TYPE_CHORUS4 = 3;
            public static final int CHORUS_TYPE_FB_CHORUS = 4;
            public static final int CHORUS_TYPE_FLANGER = 5;
            private static final short[] SLOTPATH_EFFECT_CHORUS = new short[]{258};
            private static final byte[] CHORUS_TYPE = new byte[]{0};
            private static final byte[] CHORUS_MOD_RATE = new byte[]{1};
            private static final byte[] CHORUS_MOD_DEPTH = new byte[]{2};
            private static final byte[] CHORUS_FEEDBACK = new byte[]{3};
            private static final byte[] CHORUS_SEND_TO_REVERB = new byte[]{4};

            public static SysexMessage setChorusType(int targetDevice, int reverbType) throws IOException, InvalidMidiDataException {
                return DeviceControl.setGlobalParameter(targetDevice, SLOTPATH_EFFECT_CHORUS, CHORUS_TYPE, reverbType);
            }

            public static SysexMessage setChorusModRate(int targetDevice, int reverbType) throws IOException, InvalidMidiDataException {
                return DeviceControl.setGlobalParameter(targetDevice, SLOTPATH_EFFECT_CHORUS, CHORUS_MOD_RATE, reverbType);
            }

            public static SysexMessage setChorusModDepth(int targetDevice, int reverbType) throws IOException, InvalidMidiDataException {
                return DeviceControl.setGlobalParameter(targetDevice, SLOTPATH_EFFECT_CHORUS, CHORUS_MOD_DEPTH, reverbType);
            }

            public static SysexMessage setChorusFeedback(int targetDevice, int reverbType) throws IOException, InvalidMidiDataException {
                return DeviceControl.setGlobalParameter(targetDevice, SLOTPATH_EFFECT_CHORUS, CHORUS_FEEDBACK, reverbType);
            }

            public static SysexMessage setChorusSendToReverb(int targetDevice, int reverbType) throws IOException, InvalidMidiDataException {
                return DeviceControl.setGlobalParameter(targetDevice, SLOTPATH_EFFECT_CHORUS, CHORUS_SEND_TO_REVERB, reverbType);
            }
        }

        public static class ReverbEffect {
            public static final int REVERB_TYPE_SMALL_ROOM = 0;
            public static final int REVERB_TYPE_MEDIUM_ROOM = 1;
            public static final int REVERB_TYPE_LARGE_ROOM = 2;
            public static final int REVERB_TYPE_MEDIUM_HALL = 3;
            public static final int REVERB_TYPE_LARGE_HALL = 4;
            public static final int REVERB_TYPE_PLATE = 8;
            private static final short[] SLOTPATH_EFFECT_REVERB = new short[]{257};
            private static final byte[] REVERB_TYPE = new byte[]{0};
            private static final byte[] REVERB_TIME = new byte[]{1};

            public static SysexMessage setReverbType(int targetDevice, int reverbType) throws IOException, InvalidMidiDataException {
                return DeviceControl.setGlobalParameter(targetDevice, SLOTPATH_EFFECT_REVERB, REVERB_TYPE, reverbType);
            }

            public static SysexMessage setReverbTime(int targetDevice, int reverbTime) throws IOException, InvalidMidiDataException {
                return DeviceControl.setGlobalParameter(targetDevice, SLOTPATH_EFFECT_REVERB, REVERB_TIME, reverbTime);
            }
        }
    }

    public static class GeneralMidiMessages {
        private static final byte[] GENERAL_MIDI_MESSAGES = new byte[]{9};
        private static final byte GENERAL_MIDI_1_ON = 1;
        private static final byte GENERAL_MIDI_OFF = 2;
        private static final byte GENERAL_MIDI_2_ON = 3;

        private static SysexMessage setGeneralMidiMessage(int targetDevice, byte type) throws IOException, InvalidMidiDataException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(UNIVERSAL_NON_REALTIME_SYSEX_HEADER);
            baos.write((byte)targetDevice);
            baos.write(GENERAL_MIDI_MESSAGES);
            baos.write(type);
            baos.write(EOX);
            SysexMessage sysex = new SysexMessage();
            byte[] data = baos.toByteArray();
            sysex.setMessage(data, data.length);
            return sysex;
        }

        public static SysexMessage gmSystemOff(int targetDevice) throws IOException, InvalidMidiDataException {
            return GeneralMidiMessages.setGeneralMidiMessage(targetDevice, (byte)2);
        }

        public static SysexMessage gmSystemOn(int targetDevice) throws IOException, InvalidMidiDataException {
            return GeneralMidiMessages.setGeneralMidiMessage(targetDevice, (byte)1);
        }

        public static SysexMessage gm1SystemOn(int targetDevice) throws IOException, InvalidMidiDataException {
            return GeneralMidiMessages.setGeneralMidiMessage(targetDevice, (byte)1);
        }

        public static SysexMessage gm2SystemOn(int targetDevice) throws IOException, InvalidMidiDataException {
            return GeneralMidiMessages.setGeneralMidiMessage(targetDevice, (byte)3);
        }
    }
}

