/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.com.sun.media.sound;

import io.github.tofodroid.com.sun.media.sound.SoftAbstractResampler;

public final class SoftLinearResampler2
extends SoftAbstractResampler {
    @Override
    public int getPadding() {
        return 2;
    }

    @Override
    public void interpolate(float[] in, float[] in_offset, float in_end, float[] startpitch, float pitchstep, float[] out, int[] out_offset, int out_end) {
        float pitch = startpitch[0];
        float ix = in_offset[0];
        int ox = out_offset[0];
        float ix_end = in_end;
        int ox_end = out_end;
        if (!(ix < ix_end) || ox >= ox_end) {
            return;
        }
        int p_ix = (int)(ix * 32768.0f);
        int p_ix_end = (int)(ix_end * 32768.0f);
        int p_pitch = (int)(pitch * 32768.0f);
        pitch = (float)p_pitch * 3.0517578E-5f;
        if (pitchstep == 0.0f) {
            int ox_end2;
            int p_ix_len = p_ix_end - p_ix;
            int p_mod = p_ix_len % p_pitch;
            if (p_mod != 0) {
                p_ix_len += p_pitch - p_mod;
            }
            if ((ox_end2 = ox + p_ix_len / p_pitch) < ox_end) {
                ox_end = ox_end2;
            }
            while (ox < ox_end) {
                int iix = p_ix >> 15;
                float fix = ix - (float)iix;
                float i = in[iix];
                out[ox++] = i + (in[iix + 1] - i) * fix;
                p_ix += p_pitch;
                ix += pitch;
            }
        } else {
            int p_pitchstep = (int)(pitchstep * 32768.0f);
            pitchstep = (float)p_pitchstep * 3.0517578E-5f;
            while (p_ix < p_ix_end && ox < ox_end) {
                int iix = p_ix >> 15;
                float fix = ix - (float)iix;
                float i = in[iix];
                out[ox++] = i + (in[iix + 1] - i) * fix;
                ix += pitch;
                p_ix += p_pitch;
                pitch += pitchstep;
                p_pitch += p_pitchstep;
            }
        }
        in_offset[0] = ix;
        out_offset[0] = ox;
        startpitch[0] = pitch;
    }
}

