/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.com.sun.media.sound;

import io.github.tofodroid.com.sun.media.sound.SoftAudioBuffer;
import io.github.tofodroid.com.sun.media.sound.SoftAudioProcessor;
import java.util.Arrays;

public final class SoftChorus
implements SoftAudioProcessor {
    private boolean mix = true;
    private SoftAudioBuffer inputA;
    private SoftAudioBuffer left;
    private SoftAudioBuffer right;
    private SoftAudioBuffer reverb;
    private LFODelay vdelay1L;
    private LFODelay vdelay1R;
    private float rgain = 0.0f;
    private boolean dirty = true;
    private double dirty_vdelay1L_rate;
    private double dirty_vdelay1R_rate;
    private double dirty_vdelay1L_depth;
    private double dirty_vdelay1R_depth;
    private float dirty_vdelay1L_feedback;
    private float dirty_vdelay1R_feedback;
    private float dirty_vdelay1L_reverbsendgain;
    private float dirty_vdelay1R_reverbsendgain;
    private float controlrate;
    double silentcounter = 1000.0;

    @Override
    public void init(float samplerate, float controlrate) {
        this.controlrate = controlrate;
        this.vdelay1L = new LFODelay(samplerate, controlrate);
        this.vdelay1R = new LFODelay(samplerate, controlrate);
        this.vdelay1L.setGain(1.0f);
        this.vdelay1R.setGain(1.0f);
        this.vdelay1L.setPhase(1.5707963267948966);
        this.vdelay1R.setPhase(0.0);
        this.globalParameterControlChange(new int[]{130}, 0L, 2L);
    }

    @Override
    public void globalParameterControlChange(int[] slothpath, long param, long value) {
        if (slothpath.length == 1 && slothpath[0] == 130) {
            if (param == 0L) {
                switch ((int)value) {
                    case 0: {
                        this.globalParameterControlChange(slothpath, 3L, 0L);
                        this.globalParameterControlChange(slothpath, 1L, 3L);
                        this.globalParameterControlChange(slothpath, 2L, 5L);
                        this.globalParameterControlChange(slothpath, 4L, 0L);
                        break;
                    }
                    case 1: {
                        this.globalParameterControlChange(slothpath, 3L, 5L);
                        this.globalParameterControlChange(slothpath, 1L, 9L);
                        this.globalParameterControlChange(slothpath, 2L, 19L);
                        this.globalParameterControlChange(slothpath, 4L, 0L);
                        break;
                    }
                    case 2: {
                        this.globalParameterControlChange(slothpath, 3L, 8L);
                        this.globalParameterControlChange(slothpath, 1L, 3L);
                        this.globalParameterControlChange(slothpath, 2L, 19L);
                        this.globalParameterControlChange(slothpath, 4L, 0L);
                        break;
                    }
                    case 3: {
                        this.globalParameterControlChange(slothpath, 3L, 16L);
                        this.globalParameterControlChange(slothpath, 1L, 9L);
                        this.globalParameterControlChange(slothpath, 2L, 16L);
                        this.globalParameterControlChange(slothpath, 4L, 0L);
                        break;
                    }
                    case 4: {
                        this.globalParameterControlChange(slothpath, 3L, 64L);
                        this.globalParameterControlChange(slothpath, 1L, 2L);
                        this.globalParameterControlChange(slothpath, 2L, 24L);
                        this.globalParameterControlChange(slothpath, 4L, 0L);
                        break;
                    }
                    case 5: {
                        this.globalParameterControlChange(slothpath, 3L, 112L);
                        this.globalParameterControlChange(slothpath, 1L, 1L);
                        this.globalParameterControlChange(slothpath, 2L, 5L);
                        this.globalParameterControlChange(slothpath, 4L, 0L);
                        break;
                    }
                }
            } else if (param == 1L) {
                this.dirty_vdelay1L_rate = (double)value * 0.122;
                this.dirty_vdelay1R_rate = (double)value * 0.122;
                this.dirty = true;
            } else if (param == 2L) {
                this.dirty_vdelay1L_depth = (double)(value + 1L) / 3200.0;
                this.dirty_vdelay1R_depth = (double)(value + 1L) / 3200.0;
                this.dirty = true;
            } else if (param == 3L) {
                this.dirty_vdelay1L_feedback = (float)value * 0.00763f;
                this.dirty_vdelay1R_feedback = (float)value * 0.00763f;
                this.dirty = true;
            }
            if (param == 4L) {
                this.rgain = (float)value * 0.00787f;
                this.dirty_vdelay1L_reverbsendgain = (float)value * 0.00787f;
                this.dirty_vdelay1R_reverbsendgain = (float)value * 0.00787f;
                this.dirty = true;
            }
        }
    }

    @Override
    public void processControlLogic() {
        if (this.dirty) {
            this.dirty = false;
            this.vdelay1L.setRate(this.dirty_vdelay1L_rate);
            this.vdelay1R.setRate(this.dirty_vdelay1R_rate);
            this.vdelay1L.setDepth(this.dirty_vdelay1L_depth);
            this.vdelay1R.setDepth(this.dirty_vdelay1R_depth);
            this.vdelay1L.setFeedBack(this.dirty_vdelay1L_feedback);
            this.vdelay1R.setFeedBack(this.dirty_vdelay1R_feedback);
            this.vdelay1L.setReverbSendGain(this.dirty_vdelay1L_reverbsendgain);
            this.vdelay1R.setReverbSendGain(this.dirty_vdelay1R_reverbsendgain);
        }
    }

    @Override
    public void processAudio() {
        float[] reverb;
        if (this.inputA.isSilent()) {
            this.silentcounter += (double)(1.0f / this.controlrate);
            if (this.silentcounter > 1.0) {
                if (!this.mix) {
                    this.left.clear();
                    this.right.clear();
                }
                return;
            }
        } else {
            this.silentcounter = 0.0;
        }
        float[] inputA = this.inputA.array();
        float[] left = this.left.array();
        float[] right = this.right == null ? null : this.right.array();
        float[] fArray = reverb = this.rgain != 0.0f ? this.reverb.array() : null;
        if (this.mix) {
            this.vdelay1L.processMix(inputA, left, reverb);
            if (right != null) {
                this.vdelay1R.processMix(inputA, right, reverb);
            }
        } else {
            this.vdelay1L.processReplace(inputA, left, reverb);
            if (right != null) {
                this.vdelay1R.processReplace(inputA, right, reverb);
            }
        }
    }

    @Override
    public void setInput(int pin, SoftAudioBuffer input) {
        if (pin == 0) {
            this.inputA = input;
        }
    }

    @Override
    public void setMixMode(boolean mix) {
        this.mix = mix;
    }

    @Override
    public void setOutput(int pin, SoftAudioBuffer output) {
        if (pin == 0) {
            this.left = output;
        }
        if (pin == 1) {
            this.right = output;
        }
        if (pin == 2) {
            this.reverb = output;
        }
    }

    private static class LFODelay {
        private double phase = 1.0;
        private double phase_step = 0.0;
        private double depth = 0.0;
        private VariableDelay vdelay;
        private final double samplerate;
        private final double controlrate;

        LFODelay(double samplerate, double controlrate) {
            this.samplerate = samplerate;
            this.controlrate = controlrate;
            this.vdelay = new VariableDelay((int)((this.depth + 10.0) * 2.0));
        }

        public void setDepth(double depth) {
            this.depth = depth * this.samplerate;
            this.vdelay = new VariableDelay((int)((this.depth + 10.0) * 2.0));
        }

        public void setRate(double rate) {
            double g;
            this.phase_step = g = Math.PI * 2 * (rate / this.controlrate);
        }

        public void setPhase(double phase) {
            this.phase = phase;
        }

        public void setFeedBack(float feedback) {
            this.vdelay.setFeedBack(feedback);
        }

        public void setGain(float gain) {
            this.vdelay.setGain(gain);
        }

        public void setReverbSendGain(float rgain) {
            this.vdelay.setReverbSendGain(rgain);
        }

        public void processMix(float[] in, float[] out, float[] rout) {
            this.phase += this.phase_step;
            while (this.phase > Math.PI * 2) {
                this.phase -= Math.PI * 2;
            }
            this.vdelay.setDelay((float)(this.depth * 0.5 * (Math.cos(this.phase) + 2.0)));
            this.vdelay.processMix(in, out, rout);
        }

        public void processReplace(float[] in, float[] out, float[] rout) {
            this.phase += this.phase_step;
            while (this.phase > Math.PI * 2) {
                this.phase -= Math.PI * 2;
            }
            this.vdelay.setDelay((float)(this.depth * 0.5 * (Math.cos(this.phase) + 2.0)));
            this.vdelay.processReplace(in, out, rout);
        }
    }

    private static class VariableDelay {
        private final float[] delaybuffer;
        private int rovepos = 0;
        private float gain = 1.0f;
        private float rgain = 0.0f;
        private float delay = 0.0f;
        private float lastdelay = 0.0f;
        private float feedback = 0.0f;

        VariableDelay(int maxbuffersize) {
            this.delaybuffer = new float[maxbuffersize];
        }

        public void setDelay(float delay) {
            this.delay = delay;
        }

        public void setFeedBack(float feedback) {
            this.feedback = feedback;
        }

        public void setGain(float gain) {
            this.gain = gain;
        }

        public void setReverbSendGain(float rgain) {
            this.rgain = rgain;
        }

        public void processMix(float[] in, float[] out, float[] rout) {
            float gain = this.gain;
            float delay = this.delay;
            float feedback = this.feedback;
            float[] delaybuffer = this.delaybuffer;
            int len = in.length;
            float delaydelta = (delay - this.lastdelay) / (float)len;
            int rnlen = delaybuffer.length;
            int rovepos = this.rovepos;
            if (rout == null) {
                for (int i = 0; i < len; ++i) {
                    float r = (float)rovepos - (this.lastdelay + 2.0f) + (float)rnlen;
                    int ri = (int)r;
                    float s = r - (float)ri;
                    float a = delaybuffer[ri % rnlen];
                    float b = delaybuffer[(ri + 1) % rnlen];
                    float o = a * (1.0f - s) + b * s;
                    int n = i;
                    out[n] = out[n] + o * gain;
                    delaybuffer[rovepos] = in[i] + o * feedback;
                    rovepos = (rovepos + 1) % rnlen;
                    this.lastdelay += delaydelta;
                }
            } else {
                for (int i = 0; i < len; ++i) {
                    float r = (float)rovepos - (this.lastdelay + 2.0f) + (float)rnlen;
                    int ri = (int)r;
                    float s = r - (float)ri;
                    float a = delaybuffer[ri % rnlen];
                    float b = delaybuffer[(ri + 1) % rnlen];
                    float o = a * (1.0f - s) + b * s;
                    int n = i;
                    out[n] = out[n] + o * gain;
                    int n2 = i;
                    rout[n2] = rout[n2] + o * this.rgain;
                    delaybuffer[rovepos] = in[i] + o * feedback;
                    rovepos = (rovepos + 1) % rnlen;
                    this.lastdelay += delaydelta;
                }
            }
            this.rovepos = rovepos;
            this.lastdelay = delay;
        }

        public void processReplace(float[] in, float[] out, float[] rout) {
            Arrays.fill(out, 0.0f);
            Arrays.fill(rout, 0.0f);
            this.processMix(in, out, rout);
        }
    }
}

