/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.com.sun.media.sound;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequence;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Track;

public final class MidiUtils {
    public static final int DEFAULT_TEMPO_MPQ = 500000;
    public static final int META_END_OF_TRACK_TYPE = 47;
    public static final int META_TEMPO_TYPE = 81;

    private MidiUtils() {
    }

    public static Integer isPitchBendRangeMessage(ShortMessage message, Integer flag) {
        if (message.getCommand() == 176) {
            if (message.getData1() == 100 && message.getData2() == 0) {
                return flag == 0 ? 1 : (flag == 2 ? 3 : 0);
            }
            if (message.getData1() == 101 && message.getData2() == 0) {
                return flag == 0 ? 2 : (flag == 1 ? 3 : 0);
            }
            if (message.getData1() == 6 && flag == 3) {
                return 4;
            }
        }
        return 0;
    }

    public static byte[] sequenceToByteArray(Sequence sequence) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int[] types = MidiSystem.getMidiFileTypes(sequence);
        MidiSystem.write(sequence, types[0], bos);
        return bos.toByteArray();
    }

    public static Sequence byteArrayToSequence(byte[] bytes) throws IOException, InvalidMidiDataException {
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        return MidiSystem.getSequence(bis);
    }

    static RuntimeException unsupportedDevice(MidiDevice.Info info) {
        return new IllegalArgumentException(String.format("MidiDevice %s not supported by this provider", info));
    }

    public static void checkSysexStatus(byte[] data, int length) throws InvalidMidiDataException {
        if (data.length == 0 || length == 0) {
            throw new InvalidMidiDataException("Status byte is missing");
        }
        MidiUtils.checkSysexStatus(data[0] & 0xFF);
    }

    public static void checkSysexStatus(int status) throws InvalidMidiDataException {
        if (status != 240 && status != 247) {
            throw new InvalidMidiDataException(String.format("Invalid status byte for sysex message: 0x%X", status));
        }
    }

    public static boolean isMetaEndOfTrack(MidiMessage midiMsg) {
        if (midiMsg.getLength() != 3 || midiMsg.getStatus() != 255) {
            return false;
        }
        byte[] msg = midiMsg.getMessage();
        return (msg[1] & 0xFF) == 47 && msg[2] == 0;
    }

    public static boolean isMetaTempo(MidiMessage midiMsg) {
        if (midiMsg.getLength() != 6 || midiMsg.getStatus() != 255) {
            return false;
        }
        byte[] msg = midiMsg.getMessage();
        return (msg[1] & 0xFF) == 81 && msg[2] == 3;
    }

    public static int getTempoMPQ(MidiMessage midiMsg) {
        if (midiMsg.getLength() != 6 || midiMsg.getStatus() != 255) {
            return -1;
        }
        byte[] msg = midiMsg.getMessage();
        if ((msg[1] & 0xFF) != 81 || msg[2] != 3) {
            return -1;
        }
        int tempo = msg[5] & 0xFF | (msg[4] & 0xFF) << 8 | (msg[3] & 0xFF) << 16;
        return tempo;
    }

    public static double convertTempo(double tempo) {
        if (tempo <= 0.0) {
            tempo = 1.0;
        }
        return 6.0E7 / tempo;
    }

    public static long ticks2microsec(long tick, double tempoMPQ, int resolution) {
        return (long)((double)tick * tempoMPQ / (double)resolution);
    }

    public static long microsec2ticks(long us, double tempoMPQ, int resolution) {
        return (long)((double)us * (double)resolution / tempoMPQ);
    }

    public static long tick2microsecond(Sequence seq, long tick, TempoCache cache) {
        if (seq.getDivisionType() != 0.0f) {
            double seconds = (double)tick / (double)(seq.getDivisionType() * (float)seq.getResolution());
            return (long)(1000000.0 * seconds);
        }
        if (cache == null) {
            cache = new TempoCache(seq);
        }
        int resolution = seq.getResolution();
        long[] ticks = cache.ticks;
        int[] tempos = cache.tempos;
        int cacheCount = tempos.length;
        int snapshotIndex = cache.snapshotIndex;
        int snapshotMicro = cache.snapshotMicro;
        long us = 0L;
        if (snapshotIndex <= 0 || snapshotIndex >= cacheCount || ticks[snapshotIndex] > tick) {
            snapshotMicro = 0;
            snapshotIndex = 0;
        }
        if (cacheCount > 0) {
            int i = snapshotIndex + 1;
            while (i < cacheCount && ticks[i] <= tick) {
                snapshotMicro = (int)((long)snapshotMicro + MidiUtils.ticks2microsec(ticks[i] - ticks[i - 1], tempos[i - 1], resolution));
                snapshotIndex = i++;
            }
            us = (long)snapshotMicro + MidiUtils.ticks2microsec(tick - ticks[snapshotIndex], tempos[snapshotIndex], resolution);
        }
        cache.snapshotIndex = snapshotIndex;
        cache.snapshotMicro = snapshotMicro;
        return us;
    }

    public static long microsecond2tick(Sequence seq, long micros, TempoCache cache) {
        int i;
        if (seq.getDivisionType() != 0.0f) {
            double dTick = (double)micros * (double)seq.getDivisionType() * (double)seq.getResolution() / 1000000.0;
            long tick = (long)dTick;
            if (cache != null) {
                cache.currTempo = (int)cache.getTempoMPQAt(tick);
            }
            return tick;
        }
        if (cache == null) {
            cache = new TempoCache(seq);
        }
        long[] ticks = cache.ticks;
        int[] tempos = cache.tempos;
        int cacheCount = tempos.length;
        int resolution = seq.getResolution();
        long us = 0L;
        long tick = 0L;
        if (micros > 0L && cacheCount > 0) {
            long nextTime;
            for (i = 1; i < cacheCount && (nextTime = us + MidiUtils.ticks2microsec(ticks[i] - ticks[i - 1], tempos[i - 1], resolution)) <= micros; ++i) {
                us = nextTime;
            }
            tick = ticks[i - 1] + MidiUtils.microsec2ticks(micros - us, tempos[i - 1], resolution);
        }
        cache.currTempo = tempos[i - 1];
        return tick;
    }

    public static int tick2index(Track track, long tick) {
        int ret = 0;
        if (tick > 0L) {
            long t;
            int low = 0;
            int high = track.size() - 1;
            while (low < high && (t = track.get(ret = low + high >> 1).getTick()) != tick) {
                if (t < tick) {
                    if (low == high - 1) {
                        ++ret;
                        break;
                    }
                    low = ret;
                    continue;
                }
                high = ret;
            }
        }
        return ret;
    }

    public static final class TempoCache {
        long[] ticks = new long[1];
        int[] tempos = new int[1];
        int snapshotIndex = 0;
        int snapshotMicro = 0;
        int currTempo;
        private boolean firstTempoIsFake = false;

        public TempoCache() {
            this.tempos[0] = 500000;
            this.snapshotIndex = 0;
            this.snapshotMicro = 0;
        }

        public TempoCache(Sequence seq) {
            this();
            this.refresh(seq);
        }

        public synchronized void refresh(Sequence seq) {
            int i;
            ArrayList<MidiEvent> list = new ArrayList<MidiEvent>();
            Track[] tracks = seq.getTracks();
            if (tracks.length > 0) {
                Track track = tracks[0];
                int c = track.size();
                for (i = 0; i < c; ++i) {
                    MidiEvent ev = track.get(i);
                    MidiMessage msg = ev.getMessage();
                    if (!MidiUtils.isMetaTempo(msg)) continue;
                    list.add(ev);
                }
            }
            int size = list.size() + 1;
            this.firstTempoIsFake = true;
            if (size > 1 && ((MidiEvent)list.get(0)).getTick() == 0L) {
                --size;
                this.firstTempoIsFake = false;
            }
            this.ticks = new long[size];
            this.tempos = new int[size];
            int e = 0;
            if (this.firstTempoIsFake) {
                this.ticks[0] = 0L;
                this.tempos[0] = 500000;
                ++e;
            }
            i = 0;
            while (i < list.size()) {
                MidiEvent evt = (MidiEvent)list.get(i);
                this.ticks[e] = evt.getTick();
                this.tempos[e] = MidiUtils.getTempoMPQ(evt.getMessage());
                ++i;
                ++e;
            }
            this.snapshotIndex = 0;
            this.snapshotMicro = 0;
        }

        public int getCurrTempoMPQ() {
            return this.currTempo;
        }

        float getTempoMPQAt(long tick) {
            return this.getTempoMPQAt(tick, -1.0f);
        }

        synchronized float getTempoMPQAt(long tick, float startTempoMPQ) {
            for (int i = 0; i < this.ticks.length; ++i) {
                if (this.ticks[i] <= tick) continue;
                if (i > 0) {
                    --i;
                }
                if (startTempoMPQ > 0.0f && i == 0 && this.firstTempoIsFake) {
                    return startTempoMPQ;
                }
                return this.tempos[i];
            }
            return this.tempos[this.tempos.length - 1];
        }
    }
}

