/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.com.sun.media.sound;

import io.github.tofodroid.com.sun.media.sound.AutoClosingClip;
import io.github.tofodroid.com.sun.media.sound.DataPusher;
import io.github.tofodroid.com.sun.media.sound.Printer;
import io.github.tofodroid.com.sun.media.sound.Toolkit;
import java.applet.AudioClip;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaEventListener;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiFileFormat;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;

public final class JavaSoundAudioClip
implements AudioClip,
MetaEventListener,
LineListener {
    private long lastPlayCall = 0L;
    private static final int MINIMUM_PLAY_DELAY = 30;
    private byte[] loadedAudio = null;
    private int loadedAudioByteLength = 0;
    private AudioFormat loadedAudioFormat = null;
    private AutoClosingClip clip = null;
    private boolean clipLooping = false;
    private DataPusher datapusher = null;
    private Sequencer sequencer = null;
    private Sequence sequence = null;
    private boolean sequencerloop = false;
    private volatile boolean success;
    private static final long CLIP_THRESHOLD = 0x100000L;
    private static final int STREAM_BUFFER_SIZE = 1024;

    public static JavaSoundAudioClip create(URLConnection uc) {
        JavaSoundAudioClip clip = new JavaSoundAudioClip();
        try {
            clip.init(uc.getInputStream());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return clip;
    }

    public static JavaSoundAudioClip create(URL url) {
        JavaSoundAudioClip clip = new JavaSoundAudioClip();
        try {
            clip.init(url.openStream());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return clip;
    }

    private void init(InputStream in) throws IOException {
        BufferedInputStream bis = new BufferedInputStream(in, 1024);
        bis.mark(1024);
        try {
            AudioInputStream as = AudioSystem.getAudioInputStream(bis);
            this.success = this.loadAudioData(as);
            if (this.success) {
                this.success = false;
                if ((long)this.loadedAudioByteLength < 0x100000L) {
                    this.success = this.createClip();
                }
                if (!this.success) {
                    this.success = this.createSourceDataLine();
                }
            }
        }
        catch (UnsupportedAudioFileException e) {
            try {
                MidiFileFormat mff = MidiSystem.getMidiFileFormat(bis);
                this.success = this.createSequencer(bis);
            }
            catch (InvalidMidiDataException e1) {
                this.success = false;
            }
        }
    }

    @Override
    public synchronized void play() {
        if (!this.success) {
            return;
        }
        this.startImpl(false);
    }

    @Override
    public synchronized void loop() {
        if (!this.success) {
            return;
        }
        this.startImpl(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void startImpl(boolean loop) {
        block22: {
            long currentTime = System.currentTimeMillis();
            long diff = currentTime - this.lastPlayCall;
            if (diff < 30L) {
                return;
            }
            this.lastPlayCall = currentTime;
            try {
                block23: {
                    if (this.clip != null) {
                        this.clip.setAutoClosing(false);
                        try {
                            if (!this.clip.isOpen()) {
                                this.clip.open(this.loadedAudioFormat, this.loadedAudio, 0, this.loadedAudioByteLength);
                            } else {
                                this.clip.flush();
                                if (loop != this.clipLooping) {
                                    this.clip.stop();
                                }
                            }
                            this.clip.setFramePosition(0);
                            if (loop) {
                                this.clip.loop(-1);
                            } else {
                                this.clip.start();
                            }
                            this.clipLooping = loop;
                            break block22;
                        }
                        finally {
                            this.clip.setAutoClosing(true);
                        }
                    }
                    if (this.datapusher != null) {
                        this.datapusher.start(loop);
                        break block22;
                    }
                    if (this.sequencer == null) break block22;
                    this.sequencerloop = loop;
                    if (this.sequencer.isRunning()) {
                        this.sequencer.setMicrosecondPosition(0L);
                    }
                    if (!this.sequencer.isOpen()) {
                        try {
                            this.sequencer.open();
                            this.sequencer.setSequence(this.sequence);
                        }
                        catch (InvalidMidiDataException e1) {
                            if (Printer.err) {
                                e1.printStackTrace();
                            }
                        }
                        catch (MidiUnavailableException e2) {
                            if (!Printer.err) break block23;
                            e2.printStackTrace();
                        }
                    }
                }
                this.sequencer.addMetaEventListener(this);
                try {
                    this.sequencer.start();
                }
                catch (Exception e) {
                    if (Printer.err) {
                        e.printStackTrace();
                    }
                }
            }
            catch (Exception e) {
                if (!Printer.err) break block22;
                e.printStackTrace();
            }
        }
    }

    @Override
    public synchronized void stop() {
        block15: {
            if (!this.success) {
                return;
            }
            this.lastPlayCall = 0L;
            if (this.clip != null) {
                block14: {
                    try {
                        this.clip.flush();
                    }
                    catch (Exception e1) {
                        if (!Printer.err) break block14;
                        e1.printStackTrace();
                    }
                }
                try {
                    this.clip.stop();
                }
                catch (Exception e2) {
                    if (Printer.err) {
                        e2.printStackTrace();
                    }
                    break block15;
                }
            }
            if (this.datapusher != null) {
                this.datapusher.stop();
            } else if (this.sequencer != null) {
                block16: {
                    try {
                        this.sequencerloop = false;
                        this.sequencer.removeMetaEventListener(this);
                        this.sequencer.stop();
                    }
                    catch (Exception e3) {
                        if (!Printer.err) break block16;
                        e3.printStackTrace();
                    }
                }
                try {
                    this.sequencer.close();
                }
                catch (Exception e4) {
                    if (!Printer.err) break block15;
                    e4.printStackTrace();
                }
            }
        }
    }

    @Override
    public synchronized void update(LineEvent event) {
    }

    @Override
    public synchronized void meta(MetaMessage message) {
        if (message.getType() == 47) {
            if (this.sequencerloop) {
                this.sequencer.setMicrosecondPosition(0L);
                this.loop();
            } else {
                this.stop();
            }
        }
    }

    public String toString() {
        return this.getClass().toString();
    }

    protected void finalize() {
        if (this.clip != null) {
            this.clip.close();
        }
        if (this.datapusher != null) {
            this.datapusher.close();
        }
        if (this.sequencer != null) {
            this.sequencer.close();
        }
    }

    private boolean loadAudioData(AudioInputStream as) throws IOException, UnsupportedAudioFileException {
        if ((as = Toolkit.getPCMConvertedAudioInputStream(as)) == null) {
            return false;
        }
        this.loadedAudioFormat = as.getFormat();
        long frameLen = as.getFrameLength();
        int frameSize = this.loadedAudioFormat.getFrameSize();
        long byteLen = -1L;
        if (frameLen != -1L && frameLen > 0L && frameSize != -1 && frameSize > 0) {
            byteLen = frameLen * (long)frameSize;
        }
        if (byteLen != -1L) {
            this.readStream(as, byteLen);
        } else {
            this.readStream(as);
        }
        return true;
    }

    private void readStream(AudioInputStream as, long byteLen) throws IOException {
        int intLen = byteLen > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)byteLen;
        this.loadedAudio = new byte[intLen];
        this.loadedAudioByteLength = 0;
        while (true) {
            int bytesRead;
            if ((bytesRead = as.read(this.loadedAudio, this.loadedAudioByteLength, intLen - this.loadedAudioByteLength)) <= 0) break;
            this.loadedAudioByteLength += bytesRead;
        }
        as.close();
    }

    private void readStream(AudioInputStream as) throws IOException {
        int totalBytesRead;
        DirectBAOS baos = new DirectBAOS();
        try (AudioInputStream audioInputStream = as;){
            totalBytesRead = (int)as.transferTo(baos);
        }
        this.loadedAudio = baos.getInternalBuffer();
        this.loadedAudioByteLength = totalBytesRead;
    }

    private boolean createClip() {
        try {
            DataLine.Info info = new DataLine.Info(Clip.class, this.loadedAudioFormat);
            if (!AudioSystem.isLineSupported(info)) {
                if (Printer.err) {
                    Printer.err("Clip not supported: " + String.valueOf(this.loadedAudioFormat));
                }
                return false;
            }
            Line line = AudioSystem.getLine(info);
            if (!(line instanceof AutoClosingClip)) {
                if (Printer.err) {
                    Printer.err("Clip is not auto closing!" + String.valueOf(this.clip));
                }
                return false;
            }
            this.clip = (AutoClosingClip)line;
            this.clip.setAutoClosing(true);
        }
        catch (Exception e) {
            if (Printer.err) {
                e.printStackTrace();
            }
            return false;
        }
        return this.clip != null;
    }

    private boolean createSourceDataLine() {
        try {
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, this.loadedAudioFormat);
            if (!AudioSystem.isLineSupported(info)) {
                if (Printer.err) {
                    Printer.err("Line not supported: " + String.valueOf(this.loadedAudioFormat));
                }
                return false;
            }
            SourceDataLine source = (SourceDataLine)AudioSystem.getLine(info);
            this.datapusher = new DataPusher(source, this.loadedAudioFormat, this.loadedAudio, this.loadedAudioByteLength);
        }
        catch (Exception e) {
            if (Printer.err) {
                e.printStackTrace();
            }
            return false;
        }
        return this.datapusher != null;
    }

    private boolean createSequencer(BufferedInputStream in) throws IOException {
        try {
            this.sequencer = MidiSystem.getSequencer();
        }
        catch (MidiUnavailableException me) {
            if (Printer.err) {
                me.printStackTrace();
            }
            return false;
        }
        if (this.sequencer == null) {
            return false;
        }
        try {
            this.sequence = MidiSystem.getSequence(in);
            if (this.sequence == null) {
                return false;
            }
        }
        catch (InvalidMidiDataException e) {
            if (Printer.err) {
                e.printStackTrace();
            }
            return false;
        }
        return true;
    }

    private static class DirectBAOS
    extends ByteArrayOutputStream {
        DirectBAOS() {
        }

        public byte[] getInternalBuffer() {
            return this.buf;
        }
    }
}

