/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.com.sun.media.sound;

import io.github.tofodroid.com.sun.media.sound.AiffFileFormat;
import io.github.tofodroid.com.sun.media.sound.StandardFileFormat;
import io.github.tofodroid.com.sun.media.sound.SunFileReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.UnsupportedAudioFileException;

public final class AiffFileReader
extends SunFileReader {
    @Override
    StandardFileFormat getAudioFileFormatImpl(InputStream stream) throws UnsupportedAudioFileException, IOException {
        long totallength;
        DataInputStream dis = new DataInputStream(stream);
        AudioFormat format = null;
        int magic = dis.readInt();
        if (magic != 1179603533) {
            throw new UnsupportedAudioFileException("not an AIFF file");
        }
        long frameLength = 0L;
        int length = dis.readInt();
        int iffType = dis.readInt();
        if (length <= 0) {
            length = -1;
            totallength = -1L;
        } else {
            totallength = length + 8;
        }
        boolean aifc = false;
        if (iffType == 1095321155) {
            aifc = true;
        }
        boolean ssndFound = false;
        while (!ssndFound) {
            int toSkip;
            int chunkName = dis.readInt();
            int chunkLen = dis.readInt();
            int chunkRead = 0;
            switch (chunkName) {
                case 1180058962: {
                    break;
                }
                case 1129270605: {
                    if (!aifc && chunkLen < 18 || aifc && chunkLen < 22) {
                        throw new UnsupportedAudioFileException("Invalid AIFF/COMM chunksize");
                    }
                    int channels = dis.readUnsignedShort();
                    if (channels <= 0) {
                        throw new UnsupportedAudioFileException("Invalid number of channels");
                    }
                    frameLength = (long)dis.readInt() & 0xFFFFFFFFL;
                    int sampleSizeInBits = dis.readUnsignedShort();
                    if (sampleSizeInBits < 1 || sampleSizeInBits > 32) {
                        throw new UnsupportedAudioFileException("Invalid AIFF/COMM sampleSize");
                    }
                    float sampleRate = (float)this.read_ieee_extended(dis);
                    chunkRead += 18;
                    AudioFormat.Encoding encoding = AudioFormat.Encoding.PCM_SIGNED;
                    if (aifc) {
                        int enc = dis.readInt();
                        chunkRead += 4;
                        switch (enc) {
                            case 1313820229: {
                                encoding = AudioFormat.Encoding.PCM_SIGNED;
                                break;
                            }
                            case 1970037111: {
                                encoding = AudioFormat.Encoding.ULAW;
                                sampleSizeInBits = 8;
                                break;
                            }
                            default: {
                                throw new UnsupportedAudioFileException("Invalid AIFF encoding");
                            }
                        }
                    }
                    int frameSize = AiffFileReader.calculatePCMFrameSize(sampleSizeInBits, channels);
                    format = new AudioFormat(encoding, sampleRate, sampleSizeInBits, channels, frameSize, sampleRate, true);
                    break;
                }
                case 1397968452: {
                    chunkRead += 8;
                    ssndFound = true;
                }
            }
            if (ssndFound || (toSkip = chunkLen - chunkRead) <= 0) continue;
            dis.skipBytes(toSkip);
        }
        if (format == null) {
            throw new UnsupportedAudioFileException("missing COMM chunk");
        }
        AudioFileFormat.Type type = aifc ? AudioFileFormat.Type.AIFC : AudioFileFormat.Type.AIFF;
        return new AiffFileFormat(type, totallength, format, frameLength);
    }

    private double read_ieee_extended(DataInputStream dis) throws IOException {
        double f = 0.0;
        int expon = 0;
        long hiMant = 0L;
        long loMant = 0L;
        double HUGE = 3.4028234663852886E38;
        expon = dis.readUnsignedShort();
        long t1 = dis.readUnsignedShort();
        long t2 = dis.readUnsignedShort();
        hiMant = t1 << 16 | t2;
        t1 = dis.readUnsignedShort();
        t2 = dis.readUnsignedShort();
        loMant = t1 << 16 | t2;
        if (expon == 0 && hiMant == 0L && loMant == 0L) {
            f = 0.0;
        } else if (expon == Short.MAX_VALUE) {
            f = HUGE;
        } else {
            expon -= 16383;
            f = (double)hiMant * Math.pow(2.0, expon -= 31);
            f += (double)loMant * Math.pow(2.0, expon -= 32);
        }
        return f;
    }
}

