/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.com.sun.media.sound;

import io.github.tofodroid.com.sun.media.sound.AbstractDataLine;
import io.github.tofodroid.com.sun.media.sound.AbstractLine;
import io.github.tofodroid.com.sun.media.sound.Printer;
import java.util.ArrayList;
import java.util.Vector;
import javax.sound.sampled.Control;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;

abstract class AbstractMixer
extends AbstractLine
implements Mixer {
    protected static final int PCM = 0;
    protected static final int ULAW = 1;
    protected static final int ALAW = 2;
    private final Mixer.Info mixerInfo;
    protected Line.Info[] sourceLineInfo;
    protected Line.Info[] targetLineInfo;
    private boolean started = false;
    private boolean manuallyOpened = false;
    private final Vector<Line> sourceLines = new Vector();
    private final Vector<Line> targetLines = new Vector();

    protected AbstractMixer(Mixer.Info mixerInfo, Control[] controls, Line.Info[] sourceLineInfo, Line.Info[] targetLineInfo) {
        super(new Line.Info(Mixer.class), null, controls);
        this.mixer = this;
        if (controls == null) {
            controls = new Control[]{};
        }
        this.mixerInfo = mixerInfo;
        this.sourceLineInfo = sourceLineInfo;
        this.targetLineInfo = targetLineInfo;
    }

    @Override
    public final Mixer.Info getMixerInfo() {
        return this.mixerInfo;
    }

    @Override
    public final Line.Info[] getSourceLineInfo() {
        Line.Info[] localArray = new Line.Info[this.sourceLineInfo.length];
        System.arraycopy(this.sourceLineInfo, 0, localArray, 0, this.sourceLineInfo.length);
        return localArray;
    }

    @Override
    public final Line.Info[] getTargetLineInfo() {
        Line.Info[] localArray = new Line.Info[this.targetLineInfo.length];
        System.arraycopy(this.targetLineInfo, 0, localArray, 0, this.targetLineInfo.length);
        return localArray;
    }

    @Override
    public final Line.Info[] getSourceLineInfo(Line.Info info) {
        int i;
        ArrayList<Line.Info> vec = new ArrayList<Line.Info>();
        for (i = 0; i < this.sourceLineInfo.length; ++i) {
            if (!info.matches(this.sourceLineInfo[i])) continue;
            vec.add(this.sourceLineInfo[i]);
        }
        Line.Info[] returnedArray = new Line.Info[vec.size()];
        for (i = 0; i < returnedArray.length; ++i) {
            returnedArray[i] = (Line.Info)vec.get(i);
        }
        return returnedArray;
    }

    @Override
    public final Line.Info[] getTargetLineInfo(Line.Info info) {
        int i;
        ArrayList<Line.Info> vec = new ArrayList<Line.Info>();
        for (i = 0; i < this.targetLineInfo.length; ++i) {
            if (!info.matches(this.targetLineInfo[i])) continue;
            vec.add(this.targetLineInfo[i]);
        }
        Line.Info[] returnedArray = new Line.Info[vec.size()];
        for (i = 0; i < returnedArray.length; ++i) {
            returnedArray[i] = (Line.Info)vec.get(i);
        }
        return returnedArray;
    }

    @Override
    public final boolean isLineSupported(Line.Info info) {
        int i;
        for (i = 0; i < this.sourceLineInfo.length; ++i) {
            if (!info.matches(this.sourceLineInfo[i])) continue;
            return true;
        }
        for (i = 0; i < this.targetLineInfo.length; ++i) {
            if (!info.matches(this.targetLineInfo[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public abstract Line getLine(Line.Info var1) throws LineUnavailableException;

    @Override
    public abstract int getMaxLines(Line.Info var1);

    protected abstract void implOpen() throws LineUnavailableException;

    protected abstract void implStart();

    protected abstract void implStop();

    protected abstract void implClose();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Line[] getSourceLines() {
        Line[] localLines;
        Vector<Line> vector = this.sourceLines;
        synchronized (vector) {
            localLines = new Line[this.sourceLines.size()];
            for (int i = 0; i < localLines.length; ++i) {
                localLines[i] = this.sourceLines.elementAt(i);
            }
        }
        return localLines;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Line[] getTargetLines() {
        Line[] localLines;
        Vector<Line> vector = this.targetLines;
        synchronized (vector) {
            localLines = new Line[this.targetLines.size()];
            for (int i = 0; i < localLines.length; ++i) {
                localLines[i] = this.targetLines.elementAt(i);
            }
        }
        return localLines;
    }

    @Override
    public final void synchronize(Line[] lines, boolean maintainSync) {
        throw new IllegalArgumentException("Synchronization not supported by this mixer.");
    }

    @Override
    public final void unsynchronize(Line[] lines) {
        throw new IllegalArgumentException("Synchronization not supported by this mixer.");
    }

    @Override
    public final boolean isSynchronizationSupported(Line[] lines, boolean maintainSync) {
        return false;
    }

    @Override
    public final synchronized void open() throws LineUnavailableException {
        this.open(true);
    }

    final synchronized void open(boolean manual) throws LineUnavailableException {
        if (!this.isOpen()) {
            this.implOpen();
            this.setOpen(true);
            if (manual) {
                this.manuallyOpened = true;
            }
        }
    }

    final synchronized void open(Line line) throws LineUnavailableException {
        if (this.equals(line)) {
            return;
        }
        if (this.isSourceLine(line.getLineInfo())) {
            if (!this.sourceLines.contains(line)) {
                this.open(false);
                this.sourceLines.addElement(line);
            }
        } else if (this.isTargetLine(line.getLineInfo())) {
            if (!this.targetLines.contains(line)) {
                this.open(false);
                this.targetLines.addElement(line);
            }
        } else if (Printer.err) {
            Printer.err("Unknown line received for AbstractMixer.open(Line): " + String.valueOf(line));
        }
    }

    final synchronized void close(Line line) {
        if (this.equals(line)) {
            return;
        }
        this.sourceLines.removeElement(line);
        this.targetLines.removeElement(line);
        if (this.sourceLines.isEmpty() && this.targetLines.isEmpty() && !this.manuallyOpened) {
            this.close();
        }
    }

    @Override
    public final synchronized void close() {
        if (this.isOpen()) {
            int i;
            Line[] localLines = this.getSourceLines();
            for (i = 0; i < localLines.length; ++i) {
                localLines[i].close();
            }
            localLines = this.getTargetLines();
            for (i = 0; i < localLines.length; ++i) {
                localLines[i].close();
            }
            this.implClose();
            this.setOpen(false);
        }
        this.manuallyOpened = false;
    }

    final synchronized void start(Line line) {
        if (this.equals(line)) {
            return;
        }
        if (!this.started) {
            this.implStart();
            this.started = true;
        }
    }

    final synchronized void stop(Line line) {
        if (this.equals(line)) {
            return;
        }
        Vector localSourceLines = (Vector)this.sourceLines.clone();
        for (int i = 0; i < localSourceLines.size(); ++i) {
            AbstractDataLine sourceLine;
            if (!(localSourceLines.elementAt(i) instanceof AbstractDataLine) || !(sourceLine = (AbstractDataLine)localSourceLines.elementAt(i)).isStartedRunning() || sourceLine.equals(line)) continue;
            return;
        }
        Vector localTargetLines = (Vector)this.targetLines.clone();
        for (int i = 0; i < localTargetLines.size(); ++i) {
            AbstractDataLine targetLine;
            if (!(localTargetLines.elementAt(i) instanceof AbstractDataLine) || !(targetLine = (AbstractDataLine)localTargetLines.elementAt(i)).isStartedRunning() || targetLine.equals(line)) continue;
            return;
        }
        this.started = false;
        this.implStop();
    }

    final boolean isSourceLine(Line.Info info) {
        for (int i = 0; i < this.sourceLineInfo.length; ++i) {
            if (!info.matches(this.sourceLineInfo[i])) continue;
            return true;
        }
        return false;
    }

    final boolean isTargetLine(Line.Info info) {
        for (int i = 0; i < this.targetLineInfo.length; ++i) {
            if (!info.matches(this.targetLineInfo[i])) continue;
            return true;
        }
        return false;
    }

    final Line.Info getLineInfo(Line.Info info) {
        int i;
        if (info == null) {
            return null;
        }
        for (i = 0; i < this.sourceLineInfo.length; ++i) {
            if (!info.matches(this.sourceLineInfo[i])) continue;
            return this.sourceLineInfo[i];
        }
        for (i = 0; i < this.targetLineInfo.length; ++i) {
            if (!info.matches(this.targetLineInfo[i])) continue;
            return this.targetLineInfo[i];
        }
        return null;
    }
}

