/*
 * Decompiled with CFR 0.152.
 */
package com.saloeater.flan_fixes.botania.mixin;

import com.saloeater.flan_fixes.botania.IOwnedByPlayer;
import com.saloeater.flan_fixes.botania.IOwnedByPlayerHelper;
import com.saloeater.flan_fixes.botania.IRedStringBlock;
import com.saloeater.flan_fixes.botania.IRedStringBlockHelper;
import com.saloeater.flan_fixes.botania.ManaBurstEntityHelper;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntity;
import vazkii.botania.common.block.block_entity.red_string.RedStringBlockEntity;

@Mixin(value={RedStringBlockEntity.class}, remap=false)
public abstract class RedStringBlockEntityMixin
extends BotaniaBlockEntity
implements IRedStringBlock,
IOwnedByPlayer {
    Level level;
    public UUID ownerID;

    public RedStringBlockEntityMixin(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void writePacketNBT(CompoundTag cmp) {
        super.writePacketNBT(cmp);
        if (this.ownerID != null) {
            cmp.m_128362_("Flan:PlayerOrigin", this.ownerID);
        }
    }

    public void readPacketNBT(CompoundTag cmp) {
        super.readPacketNBT(cmp);
        if (cmp.m_128441_("Flan:PlayerOrigin")) {
            this.ownerID = cmp.m_128342_("Flan:PlayerOrigin");
        }
    }

    @Inject(method={"commonTick"}, at={@At(value="HEAD")}, locals=LocalCapture.CAPTURE_FAILEXCEPTION)
    private static void flan_fixes$commonTick_Head(Level level, BlockPos pos, BlockState state, RedStringBlockEntity self, CallbackInfo ci) {
        if (!(self instanceof IRedStringBlock)) {
            return;
        }
        IRedStringBlock redStringBlock = (IRedStringBlock)self;
        IRedStringBlockHelper.SetLevel(level, redStringBlock);
    }

    @Inject(method={"commonTick"}, at={@At(value="RETURN")}, locals=LocalCapture.CAPTURE_FAILEXCEPTION)
    private static void flan_fixes$commonTick_Tail(Level level, BlockPos pos, BlockState state, RedStringBlockEntity self, CallbackInfo ci) {
        if (!(self instanceof IRedStringBlock)) {
            return;
        }
        IRedStringBlock redStringBlock = (IRedStringBlock)self;
        IRedStringBlockHelper.SetLevel(null, redStringBlock);
    }

    @Inject(method={"setBinding"}, at={@At(value="HEAD")}, cancellable=true)
    public void flan_fixes$setBinding(BlockPos pos, CallbackInfo ci) {
        Level level = IRedStringBlockHelper.GetLevel(this);
        if (level == null) {
            ci.cancel();
            return;
        }
        UUID owner = IOwnedByPlayerHelper.getOwnerID(this);
        if (!ManaBurstEntityHelper.evaluateCanHitByUUID(level, pos, owner)) {
            ci.cancel();
        }
    }

    @Override
    public void SetLevel(Level level) {
        this.level = level;
    }

    @Override
    public Level GetLevel() {
        return this.level;
    }

    @Override
    public void setOwnerID(UUID uuid) {
        this.ownerID = uuid;
    }

    @Override
    public UUID getOwnerID() {
        return this.ownerID;
    }
}

