/*
 * Decompiled with CFR 0.152.
 */
package com.saloeater.flan_fixes.botania.mixin;

import com.saloeater.flan_fixes.botania.IOwnedByPlayer;
import com.saloeater.flan_fixes.botania.ManaBurstEntityHelper;
import io.github.flemmli97.flan.api.ClaimHandler;
import io.github.flemmli97.flan.api.permission.BuiltinPermission;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.vehicle.MinecartHopper;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MinecartHopper.class})
public abstract class MinecartHopperMixin
implements IOwnedByPlayer {
    UUID owner;

    @Override
    public void setOwnerID(UUID uuid) {
        this.owner = uuid;
    }

    @Override
    public UUID getOwnerID() {
        return this.owner;
    }

    @Inject(method={"m_38592_"}, at={@At(value="HEAD")}, cancellable=true)
    public void flan_fixes_vanilla$suckInItems(CallbackInfoReturnable<Boolean> cir) {
        if (this.owner == null) {
            cir.setReturnValue((Object)false);
            return;
        }
        MinecartHopper hopper = (MinecartHopper)this;
        if (!(hopper.m_9236_() instanceof ServerLevel)) {
            cir.setReturnValue((Object)false);
            return;
        }
        ServerLevel level = (ServerLevel)hopper.m_9236_();
        ServerPlayer minecartOwner = ManaBurstEntityHelper.getPlayerByUUID((Level)level, this.owner);
        if (minecartOwner == null) {
            cir.setReturnValue((Object)false);
            return;
        }
        BlockPos containerPos = hopper.m_20183_().m_121945_(Direction.UP);
        boolean canInteract = ClaimHandler.canInteract((ServerPlayer)minecartOwner, (BlockPos)containerPos, (ResourceLocation)BuiltinPermission.OPENCONTAINER);
        if (!canInteract) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"m_7378_"}, at={@At(value="TAIL")})
    private void flan_fixes_vanilla$readAdditionalSaveData(CompoundTag tag, CallbackInfo ci) {
        if (tag.m_128403_("Flan:PlayerOrigin")) {
            this.owner = tag.m_128342_("Flan:PlayerOrigin");
        }
    }

    @Inject(method={"m_7380_"}, at={@At(value="TAIL")})
    private void flan_fixes_vanilla$addAdditionalSaveData(CompoundTag tag, CallbackInfo ci) {
        if (this.owner != null) {
            tag.m_128362_("Flan:PlayerOrigin", this.owner);
        }
    }
}

