/*
 * Decompiled with CFR 0.152.
 */
package com.saloeater.flan_fixes.botania.mixin;

import com.saloeater.flan_fixes.botania.IOwnedByPlayer;
import com.saloeater.flan_fixes.botania.IStorage;
import com.saloeater.flan_fixes.botania.IStorageHelper;
import com.saloeater.flan_fixes.botania.ManaBurstEntityHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import vazkii.botania.api.internal.ManaBurst;
import vazkii.botania.common.entity.ManaBurstEntity;

@Mixin(value={ManaBurstEntity.class}, remap=false)
public abstract class ManaBurstEntityMixin
extends Projectile
implements IOwnedByPlayer,
IStorage {
    public UUID ownerID;
    public BlockPos pos;
    public final Map<String, Boolean> positionsCache = new HashMap<String, Boolean>();

    public ManaBurstEntityMixin(EntityType<? extends ThrowableProjectile> p_37466_, Level p_37467_) {
        super(p_37466_, p_37467_);
    }

    public void m_5602_(@Nullable Entity owner) {
        super.m_5602_(owner);
        this.setOwnerID(owner != null ? owner.m_20148_() : null);
    }

    @Shadow
    protected abstract void m_8060_(@NotNull BlockHitResult var1);

    @Shadow
    protected abstract void m_5790_(@NotNull EntityHitResult var1);

    public void m_6532_(@NotNull HitResult hit) {
        super.m_6532_(hit);
        ManaBurstEntity burst = (ManaBurstEntity)this;
        if (!this.canHitResultCached(burst, hit)) {
            return;
        }
        if (burst.isFake()) {
            if (hit.m_6662_() == HitResult.Type.BLOCK) {
                this.m_8060_((BlockHitResult)hit);
            } else if (hit.m_6662_() == HitResult.Type.ENTITY) {
                this.m_5790_((EntityHitResult)hit);
            }
        } else {
            super.m_6532_(hit);
        }
    }

    public boolean canHitResultCached(ManaBurstEntity burst, @NotNull HitResult hit) {
        BlockPos pos = this.getPos(hit, burst);
        Boolean cached = IStorageHelper.get(this, IStorageHelper.getBlockPosKey(pos));
        if (cached != null) {
            return cached;
        }
        boolean canHit = this.canHitResult(hit);
        IStorageHelper.set(this, IStorageHelper.getBlockPosKey(pos), canHit);
        return canHit;
    }

    public BlockPos getPos(HitResult hit, ManaBurstEntity burstEntity) {
        if (hit.m_6662_() == HitResult.Type.BLOCK) {
            return ((BlockHitResult)hit).m_82425_();
        }
        if (hit.m_6662_() == HitResult.Type.ENTITY) {
            return ((EntityHitResult)hit).m_82443_().m_20097_();
        }
        return burstEntity.m_20097_();
    }

    public boolean canHitResult(HitResult hit) {
        if (hit.m_6662_() == HitResult.Type.BLOCK) {
            BlockPos pos = ((BlockHitResult)hit).m_82425_();
            return this.canLensHit(pos);
        }
        if (hit.m_6662_() == HitResult.Type.ENTITY) {
            EntityHitResult entityHit = (EntityHitResult)hit;
            return this.canLensHit(entityHit.m_82443_().m_20097_());
        }
        return false;
    }

    public boolean canLensHit(BlockPos pos) {
        if (pos == null) {
            return true;
        }
        ManaBurstEntity entity = (ManaBurstEntity)this;
        return ManaBurstEntityHelper.evaluateCanPlayerHitByManaBurst(pos, (ManaBurst)entity);
    }

    @Inject(method={"m_7380_"}, at={@At(value="TAIL")})
    public void flan_fixes$addAdditionalSaveData(CompoundTag tag, CallbackInfo ci) {
        if (this.getOwnerID() != null) {
            tag.m_128362_("Flan:PlayerOrigin", this.getOwnerID());
        }
    }

    @Inject(method={"m_7378_"}, at={@At(value="TAIL")})
    public void flan_fixes$readAdditionalSaveData(CompoundTag tag, CallbackInfo ci) {
        if (tag.m_128441_("Flan:PlayerOrigin")) {
            this.setOwnerID(tag.m_128342_("Flan:PlayerOrigin"));
        }
    }

    @Override
    @Unique
    public void setOwnerID(UUID uuid) {
        this.ownerID = uuid;
    }

    @Override
    @Unique
    public UUID getOwnerID() {
        return this.ownerID;
    }

    @Override
    public void set(String uuid, Boolean value) {
        this.positionsCache.put(uuid, value);
    }

    @Override
    public Boolean get(String uuid) {
        return this.positionsCache.get(uuid);
    }

    @Override
    public boolean has(String uuid) {
        return this.positionsCache.containsKey(uuid);
    }
}

