/*
 * Decompiled with CFR 0.152.
 */
package com.saloeater.flan_fixes.botania.mixin;

import com.saloeater.flan_fixes.botania.IStorage;
import com.saloeater.flan_fixes.botania.IStorageHelper;
import com.saloeater.flan_fixes.botania.ManaBurstEntityHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import vazkii.botania.api.internal.ManaBurst;
import vazkii.botania.common.entity.ManaBurstEntity;
import vazkii.botania.common.item.lens.LensItem;

@Mixin(value={LensItem.class}, remap=false)
public abstract class LensItemMixin {
    @Inject(method={"collideBurst"}, at={@At(value="HEAD")}, cancellable=true)
    public void flan_fixes$collideBurst(ManaBurst burst, HitResult hit, boolean isManaBlock, boolean shouldKill, ItemStack stack, CallbackInfoReturnable<Boolean> cir) {
        ThrowableProjectile throwableProjectile = burst.entity();
        if (!(throwableProjectile instanceof ManaBurstEntity)) {
            return;
        }
        ManaBurstEntity burstEntity = (ManaBurstEntity)throwableProjectile;
        BlockPos pos = this.getPos(hit, burstEntity);
        if (!this.canHitAtPos(burstEntity, pos)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"updateBurst"}, at={@At(value="HEAD")}, cancellable=true)
    public void flan_fixes$updateBurst(ManaBurst burst, ItemStack stack, CallbackInfo ci) {
        ThrowableProjectile throwableProjectile = burst.entity();
        if (!(throwableProjectile instanceof ManaBurstEntity)) {
            return;
        }
        ManaBurstEntity burstEntity = (ManaBurstEntity)throwableProjectile;
        BlockPos pos = burstEntity.m_20097_();
        if (!this.canHitAtPos(burstEntity, pos)) {
            ci.cancel();
        }
    }

    public boolean canHitAtPos(ManaBurstEntity burstEntity, BlockPos pos) {
        Boolean cachedValue = this.canHitCached((ManaBurst)burstEntity, pos);
        if (cachedValue != null) {
            return cachedValue;
        }
        boolean canHit = ManaBurstEntityHelper.evaluateCanPlayerHitByManaBurst(pos, (ManaBurst)burstEntity);
        this.setCache(burstEntity, pos, canHit);
        return canHit;
    }

    public void setCache(ManaBurstEntity burstEntity, BlockPos pos, boolean canHit) {
        if (!(burstEntity instanceof IStorage)) {
            return;
        }
        IStorage storage = (IStorage)burstEntity;
        String key = IStorageHelper.getBlockPosKey(pos);
        IStorageHelper.set(storage, key, canHit);
    }

    public Boolean canHitCached(ManaBurst burst, BlockPos pos) {
        if (!(burst instanceof IStorage)) {
            return null;
        }
        IStorage storage = (IStorage)burst;
        String key = IStorageHelper.getBlockPosKey(pos);
        if (IStorageHelper.has(storage, key)) {
            return Boolean.TRUE.equals(IStorageHelper.get(storage, key));
        }
        return null;
    }

    public BlockPos getPos(HitResult hit, ManaBurstEntity burstEntity) {
        if (hit.m_6662_() == HitResult.Type.BLOCK) {
            return ((BlockHitResult)hit).m_82425_();
        }
        if (hit.m_6662_() == HitResult.Type.ENTITY) {
            return ((EntityHitResult)hit).m_82443_().m_20097_();
        }
        return burstEntity.m_20097_();
    }
}

