/*
 * Decompiled with CFR 0.152.
 */
package com.saloeater.flan_fixes.botania.mixin;

import com.saloeater.flan_fixes.botania.IOwnedByPlayer;
import com.saloeater.flan_fixes.botania.IStorage;
import com.saloeater.flan_fixes.botania.IStorageHelper;
import com.saloeater.flan_fixes.botania.ManaBurstEntityHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import vazkii.botania.common.entity.FlameRingEntity;

@Mixin(value={FlameRingEntity.class}, remap=false)
public class FlameRingEntityMixin
implements IOwnedByPlayer,
IStorage {
    UUID owner;
    public final Map<String, Boolean> positionsCache = new HashMap<String, Boolean>();

    @Inject(method={"m_6075_"}, at={@At(value="INVOKE", target="Ljava/util/List;iterator()Ljava/util/Iterator;")}, locals=LocalCapture.CAPTURE_FAILEXCEPTION)
    public void baseTick(CallbackInfo ci, float radius, float renderRadius, AABB boundingBox, List<LivingEntity> entities) {
        FlameRingEntity ring = (FlameRingEntity)this;
        entities.removeIf(entity -> !this.canHitCached(ring.m_9236_(), entity.m_20183_()));
    }

    private boolean canHitCached(Level level, BlockPos pos) {
        String key = IStorageHelper.getBlockPosKey(pos);
        if (IStorageHelper.has(this, key)) {
            return Boolean.TRUE.equals(IStorageHelper.get(this, key));
        }
        boolean canHit = ManaBurstEntityHelper.evaluateCanHitByUUID(level, pos, this.owner);
        IStorageHelper.set(this, key, canHit);
        return canHit;
    }

    @Inject(method={"m_7378_"}, at={@At(value="TAIL")})
    public void readAdditionalSaveData(CompoundTag cmp, CallbackInfo ci) {
        if (cmp.m_128403_("Flan:PlayerOrigin")) {
            this.owner = cmp.m_128342_("Flan:PlayerOrigin");
        }
    }

    @Inject(method={"m_7380_"}, at={@At(value="TAIL")})
    public void addAdditionalSaveData(CompoundTag cmp, CallbackInfo ci) {
        if (this.owner != null) {
            cmp.m_128362_("Flan:PlayerOrigin", this.owner);
        }
    }

    @Override
    public void setOwnerID(UUID uuid) {
        this.owner = uuid;
    }

    @Override
    public UUID getOwnerID() {
        return this.owner;
    }

    @Override
    public void set(String uuid, Boolean value) {
        this.positionsCache.put(uuid, value);
    }

    @Override
    public Boolean get(String uuid) {
        return this.positionsCache.get(uuid);
    }

    @Override
    public boolean has(String uuid) {
        return this.positionsCache.containsKey(uuid);
    }
}

