/*
 * Decompiled with CFR 0.152.
 */
package com.saloeater.flan_fixes.botania.mixin;

import com.saloeater.flan_fixes.botania.BotaniaCompat;
import com.saloeater.flan_fixes.botania.IOwnedByPlayer;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import vazkii.botania.api.corporea.CorporeaRequestMatcher;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntity;
import vazkii.botania.common.block.block_entity.corporea.CorporeaIndexBlockEntity;

@Mixin(value={CorporeaIndexBlockEntity.class}, remap=false)
public abstract class CorporeaIndexBlockEntityMixin
extends BotaniaBlockEntity
implements IOwnedByPlayer {
    public UUID ownerID;

    public CorporeaIndexBlockEntityMixin(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Inject(method={"performPlayerRequest"}, at={@At(value="HEAD")}, cancellable=true)
    private void flan_fixes_botania$performPlayerRequest(ServerPlayer player, CorporeaRequestMatcher request, int count, CallbackInfo ci) {
        CorporeaIndexBlockEntity index;
        if (this.ownerID == null) {
            player.m_5661_((Component)Component.m_237113_((String)"Unable to use owner-less Corporea Index").m_130944_(new ChatFormatting[]{ChatFormatting.DARK_RED, ChatFormatting.BOLD}), true);
            ci.cancel();
        }
        if (!BotaniaCompat.canPlayerUseCorporea(player, (index = (CorporeaIndexBlockEntity)this).m_58899_())) {
            ci.cancel();
        }
    }

    public void writePacketNBT(CompoundTag cmp) {
        super.writePacketNBT(cmp);
        if (this.ownerID != null) {
            cmp.m_128362_("Flan:PlayerOrigin", this.ownerID);
        }
    }

    public void readPacketNBT(CompoundTag cmp) {
        super.readPacketNBT(cmp);
        if (cmp.m_128441_("Flan:PlayerOrigin")) {
            this.ownerID = cmp.m_128342_("Flan:PlayerOrigin");
        }
    }

    @Override
    public void setOwnerID(UUID uuid) {
        this.ownerID = uuid;
    }

    @Override
    public UUID getOwnerID() {
        return this.ownerID;
    }
}

