/*
 * Decompiled with CFR 0.152.
 */
package com.saloeater.flan_fixes.botania;

import com.saloeater.flan_fixes.botania.BotaniaCompat;
import com.saloeater.flan_fixes.botania.IOwnedByPlayer;
import com.saloeater.flan_fixes.botania.IOwnedByPlayerHelper;
import com.saloeater.flan_fixes.botania.LevelUtils;
import io.github.flemmli97.flan.claim.ClaimStorage;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import vazkii.botania.api.internal.ManaBurst;
import vazkii.botania.common.entity.ManaBurstEntity;

public class ManaBurstEntityHelper {
    public static boolean evaluateCanPlayerHitByManaBurst(BlockPos pos, ManaBurst entity) {
        ServerPlayer serverPlayer;
        ManaBurstEntity burst;
        Level level;
        if (!(entity instanceof ManaBurstEntity) || !((level = (burst = (ManaBurstEntity)entity).m_9236_()) instanceof ServerLevel)) {
            return false;
        }
        ServerLevel world = (ServerLevel)level;
        Entity entity2 = burst.m_19749_();
        if (entity2 instanceof ServerPlayer) {
            serverPlayer = (ServerPlayer)entity2;
            return ManaBurstEntityHelper.evaluateCanHitByPlayer((Level)world, pos, serverPlayer);
        }
        serverPlayer = ManaBurstEntityHelper.getOwner(burst);
        if (serverPlayer == null) {
            return false;
        }
        burst.m_5602_((Entity)serverPlayer);
        return BotaniaCompat.canLensProjectileHit(burst, pos);
    }

    public static boolean evaluateCanHitByPlayer(Level level, BlockPos pos, ServerPlayer player) {
        if (pos == null) {
            return false;
        }
        if (player == null) {
            return !ManaBurstEntityHelper.isClaimExist(pos, level);
        }
        return BotaniaCompat.canPlayerInteract(player, pos);
    }

    public static boolean evaluateCanHitByUUID(Level world, BlockPos pos, UUID ownerID) {
        return ManaBurstEntityHelper.evaluateCanHitByPlayer(world, pos, ManaBurstEntityHelper.getPlayerByUUID(world, ownerID));
    }

    @Nullable
    public static ServerPlayer getOwner(ManaBurstEntity burst) {
        if (!(burst instanceof IOwnedByPlayer)) {
            return null;
        }
        IOwnedByPlayer owner = (IOwnedByPlayer)burst;
        UUID ownerID = IOwnedByPlayerHelper.getOwnerID(owner);
        if (ownerID == null) {
            return null;
        }
        return ManaBurstEntityHelper.getPlayerByUUID(burst.m_9236_(), ownerID);
    }

    @Nullable
    public static ServerPlayer getPlayerByUUID(Level level, UUID ownerID) {
        if (ownerID == null) {
            return null;
        }
        MinecraftServer server = level.m_7654_();
        if (server == null) {
            return null;
        }
        ServerPlayer onlinePlayer = server.m_6846_().m_11259_(ownerID);
        if (onlinePlayer != null) {
            return onlinePlayer;
        }
        return LevelUtils.getFakePlayer((ServerLevel)level, ownerID);
    }

    public static boolean isClaimExist(BlockPos pos, Level level) {
        if (!(level instanceof ServerLevel)) {
            return false;
        }
        ServerLevel world = (ServerLevel)level;
        ClaimStorage storage = ClaimStorage.get((ServerLevel)world);
        return storage.getClaimAt(pos) != null;
    }
}

