/*
 * Decompiled with CFR 0.152.
 */
package com.rinko1231.skybreaker.mixin;

import com.legacy.blue_skies.entities.hostile.boss.StarlitCrusherEntity;
import com.legacy.blue_skies.entities.hostile.boss.summons.ent.EntWallEntity;
import com.legacy.blue_skies.entities.projectile.SpearEntity;
import com.legacy.blue_skies.entities.util.base.SkiesBossEntity;
import com.legacy.blue_skies.entities.util.interfaces.IStunnableMob;
import com.legacy.blue_skies.registries.SkiesParticles;
import com.rinko1231.skybreaker.config.SkyBreakerConfig;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={StarlitCrusherEntity.class})
public abstract class TreeBossMixin
extends SkiesBossEntity
implements IStunnableMob {
    @Shadow
    private int spearImmuneTime;

    public TreeBossMixin(EntityType<? extends SkiesBossEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    @Overwrite
    public boolean m_6469_(DamageSource source, float amount) {
        if (source == this.m_269291_().m_269341_()) {
            return super.m_6469_(source, amount);
        }
        if (this.getInvulTime() <= 0 && !this.isSpinning() && (source.m_19390_() || this.getWallsInDungeonArea(5.0).size() < 4) && source != this.m_269291_().m_269318_()) {
            if (this.f_20916_ <= 0 && this.m_9236_() instanceof ServerLevel) {
                ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)SkiesParticles.FALLING_LEAF, this.m_20185_(), this.m_20186_() + (double)this.m_20206_() + (double)0.1f, this.m_20189_(), 60, this.m_20191_().m_82362_() / 2.0, (double)0.1f, this.m_20191_().m_82385_() / 2.0, 0.05);
            }
            if (!this.m_9236_().m_5776_() && this.getWallsInDungeonArea(5.0).size() < 4 && this.spearImmuneTime <= 0 && source.m_269533_(DamageTypeTags.f_268524_) && this.ba_painting$permittedProjectileDamage(source).booleanValue()) {
                if (!this.isStunned()) {
                    this.setStunned(true);
                    this.setRooted(false);
                    return super.m_6469_(source, Math.min(this.m_21223_(), amount / 2.0f));
                }
                return super.m_6469_(source, amount * 0.3f);
            }
            if (source.m_19390_()) {
                ItemStack stack;
                if (source.m_7639_() instanceof Player && (stack = ((LivingEntity)source.m_7639_()).m_21205_()).m_41720_() == Items.f_42751_) {
                    return false;
                }
                return super.m_6469_(source, amount);
            }
            if (source.m_7640_() instanceof LivingEntity) {
                ItemStack stack = ((LivingEntity)source.m_7640_()).m_21205_();
                String itemId = Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_())).toString();
                if (stack.m_41720_() instanceof AxeItem || ((List)SkyBreakerConfig.itemWhitelist2.get()).contains(itemId)) {
                    if (this.isStunned()) {
                        return super.m_6469_(source, amount);
                    }
                    return super.m_6469_(source, amount * ((Double)SkyBreakerConfig.treeProtection.get()).floatValue());
                }
            }
            if (source.m_7640_() instanceof Player && (Double)SkyBreakerConfig.treeProtection2.get() < 1.0) {
                ((Player)source.m_7640_()).m_5661_((Component)Component.m_237115_((String)"gui.blue_skies.tooltip.invalid_ent_weapon"), true);
            }
            return super.m_6469_(source, Math.min(((Double)SkyBreakerConfig.treeUnwhitelistedProjectileDamageCap.get()).floatValue(), amount * ((Double)SkyBreakerConfig.treeProtection2.get()).floatValue()));
        }
        return false;
    }

    @Shadow
    public abstract void setRooted(boolean var1);

    @Shadow
    public abstract boolean isSpinning();

    @Shadow
    public abstract List<EntWallEntity> getWallsInDungeonArea(double var1);

    @Shadow
    public abstract void setStunned(boolean var1);

    @Shadow
    public abstract void m_6074_();

    @Unique
    Boolean ba_painting$permittedProjectileDamage(DamageSource source) {
        String pID = ForgeRegistries.ENTITY_TYPES.getKey((Object)Objects.requireNonNull(source.m_7640_()).m_6095_()).toString();
        return source.m_7640_() instanceof SpearEntity || ((List)SkyBreakerConfig.projectileWhitelist.get()).contains(pID);
    }
}

