/*
 * Decompiled with CFR 0.152.
 */
package umpaz.nethersdelight.common.block.entity;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import vectorwing.farmersdelight.common.block.StoveBlock;

public abstract class AbstractStoveBlockEntity<R extends AbstractCookingRecipe, RT extends RecipeType<R>>
extends BlockEntity {
    private static final VoxelShape GRILLING_AREA = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0);
    private final NonNullList<ItemStack> items;
    private final int[] cookingProgress;
    private final int[] cookingTime;
    private final RecipeManager.CachedCheck<Container, R> recipeLookup;
    private final Vec2[] itemRenderOffsets;

    protected AbstractStoveBlockEntity(BlockEntityType<?> blockEntityType, int inventorySlotCount, RT recipeType, BlockPos pos, BlockState state, Vec2[] offsets) {
        super(blockEntityType, pos, state);
        this.items = NonNullList.m_122780_((int)inventorySlotCount, (Object)ItemStack.f_41583_);
        this.cookingProgress = new int[inventorySlotCount];
        this.cookingTime = new int[inventorySlotCount];
        this.recipeLookup = RecipeManager.m_220267_(recipeType);
        this.itemRenderOffsets = new Vec2[inventorySlotCount];
        System.arraycopy(offsets, 0, this.itemRenderOffsets, 0, Math.min(inventorySlotCount, offsets.length));
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public void m_142466_(CompoundTag nbtTag) {
        super.m_142466_(nbtTag);
        this.items.clear();
        ContainerHelper.m_18980_((CompoundTag)nbtTag, this.items);
        if (nbtTag.m_128425_("CookingTimes", 11)) {
            int[] arrayCookingTimes = nbtTag.m_128465_("CookingTimes");
            System.arraycopy(arrayCookingTimes, 0, this.cookingProgress, 0, Math.min(this.cookingTime.length, arrayCookingTimes.length));
        }
        if (nbtTag.m_128425_("CookingTotalTimes", 11)) {
            int[] arrayCookingTimesTotal = nbtTag.m_128465_("CookingTotalTimes");
            System.arraycopy(arrayCookingTimesTotal, 0, this.cookingTime, 0, Math.min(this.cookingTime.length, arrayCookingTimesTotal.length));
        }
    }

    public void m_183515_(CompoundTag nbtTag) {
        super.m_183515_(nbtTag);
        ContainerHelper.m_18976_((CompoundTag)nbtTag, this.items, (boolean)true);
        nbtTag.m_128385_("CookingTimes", this.cookingProgress);
        nbtTag.m_128385_("CookingTotalTimes", this.cookingTime);
    }

    public CompoundTag m_5995_() {
        CompoundTag nbtTag = super.m_5995_();
        ContainerHelper.m_18976_((CompoundTag)nbtTag, this.items, (boolean)true);
        return nbtTag;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public static void particleTick(Level level, BlockPos pos, BlockState state, AbstractStoveBlockEntity<?, ?> stove) {
        for (int i = 0; i < stove.items.size(); ++i) {
            if (((ItemStack)stove.items.get(i)).m_41619_() || level.f_46441_.m_188501_() >= 0.2f) continue;
            Vec2 stoveItemVector = stove.getStoveItemOffset(i);
            Direction direction = (Direction)state.m_61143_((Property)StoveBlock.FACING);
            int directionIndex = direction.m_122416_();
            Vec2 offset = directionIndex % 2 == 0 ? stoveItemVector : new Vec2(stoveItemVector.f_82471_, stoveItemVector.f_82470_);
            double x = (double)pos.m_123341_() + 0.5 - (double)((float)direction.m_122429_() * offset.f_82470_) + (double)((float)direction.m_122427_().m_122429_() * offset.f_82470_);
            double y = (double)pos.m_123342_() + 1.0;
            double z = (double)pos.m_123343_() + 0.5 - (double)((float)direction.m_122431_() * offset.f_82471_) + (double)((float)direction.m_122427_().m_122431_() * offset.f_82471_);
            for (int k = 0; k < 3; ++k) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, 0.0, 5.0E-4, 0.0);
            }
        }
    }

    public static void cooldownTick(Level level, BlockPos pos, BlockState state, AbstractStoveBlockEntity<?, ?> stove) {
        boolean didChange = false;
        for (int i = 0; i < stove.items.size(); ++i) {
            if (stove.cookingProgress[i] <= 0) continue;
            didChange = true;
            stove.cookingProgress[i] = Mth.m_14045_((int)(stove.cookingProgress[i] - 2), (int)0, (int)stove.cookingTime[i]);
        }
        if (!didChange) {
            return;
        }
        AbstractStoveBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
    }

    public static void cookTick(Level level, BlockPos pos, BlockState state, AbstractStoveBlockEntity<?, ?> stove) {
        if (level == null) {
            return;
        }
        boolean didChange = false;
        if (stove.isBlockedAbove()) {
            stove.dropAllItems(level, pos, state);
            return;
        }
        for (int i = 0; i < stove.items.size(); ++i) {
            ItemStack stoveStack = (ItemStack)stove.items.get(i);
            if (stoveStack.m_41619_()) continue;
            didChange = true;
            int n = i;
            stove.cookingProgress[n] = stove.cookingProgress[n] + 1;
            if (stove.cookingProgress[i] < stove.cookingTime[i]) continue;
            SimpleContainer inventoryWrapper = new SimpleContainer(new ItemStack[]{stoveStack});
            ItemStack result = stove.recipeLookup.m_213657_((Container)inventoryWrapper, level).map(arg_0 -> AbstractStoveBlockEntity.lambda$cookTick$0((Container)inventoryWrapper, level, arg_0)).orElse(stoveStack);
            if (!result.m_246617_(level.m_246046_())) continue;
            Containers.m_18992_((Level)level, (double)((double)stove.f_58858_.m_123341_() + 0.5), (double)((double)stove.f_58858_.m_123342_() + 1.0), (double)((double)stove.f_58858_.m_123343_() + 0.5), (ItemStack)result);
            stove.items.set(i, (Object)ItemStack.f_41583_);
            level.m_7260_(pos, state, state, 3);
            level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223722_((BlockState)state));
        }
        if (!didChange) {
            return;
        }
        AbstractStoveBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
    }

    public Optional<R> getCookableRecipe(ItemStack item) {
        if (this.isBlockedAbove()) {
            return Optional.empty();
        }
        if (this.items.stream().noneMatch(ItemStack::m_41619_)) {
            return Optional.empty();
        }
        return this.recipeLookup.m_213657_((Container)new SimpleContainer(new ItemStack[]{item}), this.f_58857_);
    }

    public boolean placeFood(@Nullable Entity placer, ItemStack itemStackToPlace, int cookingTime) {
        for (int i = 0; i < this.items.size(); ++i) {
            ItemStack itemStack = (ItemStack)this.items.get(i);
            if (!itemStack.m_41619_()) continue;
            this.cookingTime[i] = cookingTime;
            this.cookingProgress[i] = 0;
            this.items.set(i, (Object)itemStackToPlace.m_41620_(1));
            this.f_58857_.m_220407_(GameEvent.f_157792_, this.m_58899_(), GameEvent.Context.m_223719_((Entity)placer, (BlockState)this.m_58900_()));
            this.markUpdated();
            return true;
        }
        return false;
    }

    public boolean isBlockedAbove() {
        if (this.f_58857_ == null) {
            return false;
        }
        BlockState above = this.f_58857_.m_8055_(this.f_58858_.m_7494_());
        return Shapes.m_83157_((VoxelShape)GRILLING_AREA, (VoxelShape)above.m_60808_((BlockGetter)this.f_58857_, this.f_58858_.m_7494_()), (BooleanOp)BooleanOp.f_82689_);
    }

    public void dropAllItems(Level level, BlockPos pos, BlockState state) {
        if (level == null) {
            return;
        }
        Containers.m_19010_((Level)level, (BlockPos)pos, this.items);
    }

    public Vec2 getStoveItemOffset(int index) {
        return this.itemRenderOffsets[index];
    }

    protected void markUpdated() {
        this.m_6596_();
        this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
    }

    public void onExtinguish() {
    }

    public void extinguish() {
        if (this.f_58857_ == null) {
            return;
        }
        this.onExtinguish();
        this.markUpdated();
    }

    private static /* synthetic */ ItemStack lambda$cookTick$0(Container inventoryWrapper, Level level, AbstractCookingRecipe recipe) {
        return recipe.m_5874_(inventoryWrapper, level.m_9598_());
    }
}

