/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.easier_sleeping.config;

import de.geheimagentnr1.easier_sleeping.config.DimensionListType;
import de.geheimagentnr1.minecraft_forge_api.AbstractMod;
import de.geheimagentnr1.minecraft_forge_api.config.AbstractConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ServerConfig
extends AbstractConfig {
    private static final Logger log = LogManager.getLogger(ServerConfig.class);
    @NotNull
    private static final String SLEEP_PERCENT_KEY = "sleep_percent";
    @NotNull
    private static final String SLEEP_MESSAGE_KEY = "sleep_message";
    @NotNull
    private static final String WAKE_MESSAGE_KEY = "wake_message";
    @NotNull
    private static final String MORNING_MESSAGE_KEY = "morning_message";
    @NotNull
    private static final String ALL_PLAYERS_REST_KEY = "all_players_rest";
    @NotNull
    private static final String DIMENSIONS_KEY = "dimensions";
    @NotNull
    private static final String DIMENSION_LIST_TYPE_KEY = "dimension_list_type";
    @NotNull
    private static final String BLOCK_BLACKLIST_KEY = "block_blacklist";
    @NotNull
    private final TreeSet<ResourceKey<Level>> dimensions = new TreeSet<ResourceKey>(Comparator.comparing(ResourceKey::m_135782_));
    @NotNull
    private final TreeSet<ResourceLocation> blockBlacklist = new TreeSet();

    public ServerConfig(@NotNull AbstractMod _abstractMod) {
        super(_abstractMod);
    }

    @NotNull
    public ModConfig.Type type() {
        return ModConfig.Type.SERVER;
    }

    public boolean isEarlyLoad() {
        return false;
    }

    protected void registerConfigValues() {
        this.registerConfigValue("Percentage of players required to skip the night.", SLEEP_PERCENT_KEY, (builder, path) -> builder.defineInRange(path, 50, 0, 100));
        this.registerConfigValue("Message shown, if a player goes to bed", SLEEP_MESSAGE_KEY, "is now in bed.");
        this.registerConfigValue("Message shown, if a player leaves his bed", WAKE_MESSAGE_KEY, "stood up.");
        this.registerConfigValue("Message shown, if the night was skipped", MORNING_MESSAGE_KEY, "Good Morning");
        this.registerConfigValue("If true, the time since last rest is reset for all players, if enough other players are successfully sleeping. So not every player has to sleep to prevent phantom spawning for him.", ALL_PLAYERS_REST_KEY, false);
        this.registerConfigValue(List.of("If dimension_list_type is set to SLEEP_ACTIVE, the list is the list of dimensions in which the sleep voting is active.", "If dimension_list_type is set to SLEEP_INACTIVE, the list is the list of dimensions in which the sleep voting is inactive."), DIMENSIONS_KEY, (builder, path) -> builder.define(path, Collections.singletonList(Objects.requireNonNull(Level.f_46428_.m_135782_()).toString()), o -> {
            if (o instanceof List) {
                List list = (List)o;
                return list.isEmpty() || list.get(0) instanceof String;
            }
            return false;
        }));
        this.registerConfigValue(List.of("If dimension_list_type is set to SLEEP_ACTIVE, the dimension list is the list of dimensions in which the sleep voting is active.", "If dimension_list_type is set to SLEEP_INACTIVE, the dimension list is the list of dimensions in which the sleep voting is inactive."), DIMENSION_LIST_TYPE_KEY, (builder, path) -> builder.defineEnum(path, (Enum)DimensionListType.SLEEP_ACTIVE));
        this.registerConfigValue("Block names of beds being ignored for sleep percentage.", BLOCK_BLACKLIST_KEY, (builder, path) -> builder.define(path, List.of(), o -> {
            if (o instanceof List) {
                List list = (List)o;
                return list.isEmpty() || list.get(0) instanceof String;
            }
            return false;
        }));
    }

    public void handleServerStartingEvent(@NotNull ServerStartingEvent event) {
        super.handleServerStartingEvent(event);
        this.checkConfig();
    }

    private synchronized void checkConfig() {
        boolean areDimensionCorrected = this.checkCorrectAndReadDimensions();
        boolean areBlocksOfBlacklistCorrected = this.checkCorrectAndReadBlockBlacklist();
        if (areDimensionCorrected || areBlocksOfBlacklistCorrected) {
            log.info("\"{}\" Server Config corrected", (Object)this.abstractMod.getModName());
            this.printValues();
        }
    }

    private synchronized boolean checkCorrectAndReadDimensions() {
        ArrayList<String> read_dimensions = new ArrayList<String>(this.getDimensionsValue());
        this.dimensions.clear();
        for (String read_dimension : read_dimensions) {
            ResourceLocation registry_name = ResourceLocation.m_135820_((String)read_dimension);
            if (registry_name != null) {
                ResourceKey registrykey = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)registry_name);
                ServerLevel serverLevel = ServerLifecycleHooks.getCurrentServer().m_129880_(registrykey);
                if (serverLevel == null) {
                    log.warn("Removed unknown dimension: {}", (Object)read_dimension);
                    continue;
                }
                this.dimensions.add((ResourceKey<Level>)registrykey);
                continue;
            }
            log.warn("Removed invalid dimension registry name {}", (Object)read_dimension);
        }
        if (this.getDimensionsValue().size() != this.dimensions.size()) {
            this.setDimensionsValue(this.dimensionsToRegistryNameList());
            return true;
        }
        return false;
    }

    @NotNull
    private synchronized ArrayList<String> dimensionsToRegistryNameList() {
        ArrayList<String> registryNames = new ArrayList<String>();
        for (ResourceKey<Level> dimension : this.dimensions) {
            registryNames.add(Objects.requireNonNull(dimension.m_135782_()).toString());
        }
        return registryNames;
    }

    public synchronized void invertDimensions() {
        ArrayList<String> newDimensionRegistryNames = new ArrayList<String>();
        for (ServerLevel serverLevel : ServerLifecycleHooks.getCurrentServer().m_129785_()) {
            ResourceKey registrykey = serverLevel.m_46472_();
            if (this.dimensions.contains(registrykey)) continue;
            newDimensionRegistryNames.add(Objects.requireNonNull(registrykey.m_135782_()).toString());
        }
        newDimensionRegistryNames.sort(String::compareTo);
        this.setDimensionsValue(newDimensionRegistryNames);
        this.checkConfig();
    }

    private synchronized boolean checkCorrectAndReadBlockBlacklist() {
        ArrayList<String> block_blacklist = new ArrayList<String>(this.getBlockBlacklist());
        this.blockBlacklist.clear();
        for (String block : block_blacklist) {
            ResourceLocation registry_name = ResourceLocation.m_135820_((String)block);
            if (registry_name != null) {
                if (BuiltInRegistries.f_256975_.m_6612_(registry_name).isPresent()) {
                    this.blockBlacklist.add(registry_name);
                    continue;
                }
                log.warn("Removed unknown block: {}", (Object)block);
                continue;
            }
            log.warn("Removed invalid block registry name {}", (Object)block);
        }
        if (this.getBlockBlacklist().size() != this.blockBlacklist.size()) {
            this.setBlockBlacklist(this.blockBlacklistToRegistryNameList());
            return true;
        }
        return false;
    }

    @NotNull
    private synchronized ArrayList<String> blockBlacklistToRegistryNameList() {
        ArrayList<String> registryNames = new ArrayList<String>();
        for (ResourceLocation block : this.blockBlacklist) {
            registryNames.add(Objects.requireNonNull(block).toString());
        }
        return registryNames;
    }

    public int getSleepPercent() {
        return (Integer)this.getValue(Integer.class, SLEEP_PERCENT_KEY);
    }

    public void setSleepPercent(int sleep_percent) {
        this.setValue(Integer.class, SLEEP_PERCENT_KEY, sleep_percent);
    }

    @NotNull
    public String getSleepMessage() {
        return (String)this.getValue(String.class, SLEEP_MESSAGE_KEY);
    }

    public void setSleepMessage(@NotNull String message) {
        this.setValue(String.class, SLEEP_MESSAGE_KEY, message);
    }

    @NotNull
    public String getWakeMessage() {
        return (String)this.getValue(String.class, WAKE_MESSAGE_KEY);
    }

    public void setWakeMessage(@NotNull String message) {
        this.setValue(String.class, WAKE_MESSAGE_KEY, message);
    }

    @NotNull
    public String getMorningMessage() {
        return (String)this.getValue(String.class, MORNING_MESSAGE_KEY);
    }

    public void setMorningMessage(@NotNull String message) {
        this.setValue(String.class, MORNING_MESSAGE_KEY, message);
    }

    public boolean getAllPlayersRest() {
        return (Boolean)this.getValue(Boolean.class, ALL_PLAYERS_REST_KEY);
    }

    public void setAllPlayersRest(boolean all_player_rest) {
        this.setValue(Boolean.class, ALL_PLAYERS_REST_KEY, all_player_rest);
    }

    @NotNull
    private List<String> getDimensionsValue() {
        return this.getListValue(String.class, DIMENSIONS_KEY);
    }

    private void setDimensionsValue(@NotNull List<String> dimensionsValue) {
        this.setValue(List.class, BLOCK_BLACKLIST_KEY, dimensionsValue);
    }

    @NotNull
    public TreeSet<ResourceKey<Level>> getDimensions() {
        return this.dimensions;
    }

    public synchronized void addDimension(@NotNull ResourceKey<Level> dimension) {
        if (!this.dimensions.contains(dimension)) {
            this.dimensions.add(dimension);
            this.setDimensionsValue(this.dimensionsToRegistryNameList());
        }
    }

    public synchronized void removeDimension(@NotNull ResourceKey<Level> dimension) {
        if (this.dimensions.contains(dimension)) {
            this.dimensions.remove(dimension);
            this.setDimensionsValue(this.dimensionsToRegistryNameList());
        }
    }

    @NotNull
    public DimensionListType getDimensionListType() {
        return (DimensionListType)((Object)this.getValue(DimensionListType.class, DIMENSION_LIST_TYPE_KEY));
    }

    public void setDimensionListType(@NotNull DimensionListType dimensionListType) {
        this.setValue(DimensionListType.class, DIMENSION_LIST_TYPE_KEY, (Object)dimensionListType);
    }

    @NotNull
    private List<String> getBlockBlacklist() {
        return this.getListValue(String.class, BLOCK_BLACKLIST_KEY);
    }

    private void setBlockBlacklist(@NotNull List<String> _blockBlacklist) {
        this.setValue(List.class, BLOCK_BLACKLIST_KEY, _blockBlacklist);
    }

    @NotNull
    public TreeSet<ResourceLocation> getIgnoredBedBlocks() {
        return this.blockBlacklist;
    }
}

