/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.library_of_exile.tooltip;

import com.robertx22.library_of_exile.tooltip.ExileTooltipOptions;
import com.robertx22.library_of_exile.tooltip.ExileTooltipUtils;
import com.robertx22.library_of_exile.tooltip.TooltipItem;
import com.robertx22.library_of_exile.tooltip.order.ExileTooltipPart;
import com.robertx22.library_of_exile.tooltip.register.ExileTooltipHook;
import com.robertx22.library_of_exile.tooltip.register.ExileTooltipHooks;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import net.minecraft.network.chat.Component;

public class TooltipBuilder<T extends TooltipItem> {
    public T item;
    private List<Function<T, ExileTooltipPart>> parts = new ArrayList<Function<T, ExileTooltipPart>>();
    private boolean addedHooks = false;

    public TooltipBuilder(T item) {
        this.item = item;
    }

    public TooltipBuilder<T> add(Function<T, ExileTooltipPart> p) {
        this.parts.add(p);
        return this;
    }

    public List<Component> build() {
        return this.build(new ExileTooltipOptions());
    }

    public List<Component> build(ExileTooltipOptions options) {
        if (!this.addedHooks) {
            for (ExileTooltipHook hook : (List)ExileTooltipHooks.map.getOrDefault(((TooltipItem)this.item).id, new ArrayList())) {
                hook.apply(this);
            }
            this.addedHooks = true;
        }
        List<Component> tip = new ArrayList<Component>();
        ArrayList<ExileTooltipPart> allParts = new ArrayList<ExileTooltipPart>();
        for (Function<T, ExileTooltipPart> part : this.parts) {
            allParts.add(part.apply(this.item));
        }
        allParts.sort(Comparator.comparingInt(x -> x.order.order));
        int i = 0;
        for (ExileTooltipPart part : allParts) {
            ++i;
            if (part.text.isEmpty()) continue;
            tip.addAll(part.text);
            if (!options.addSpaceInBetween || i >= allParts.size()) continue;
            tip.add((Component)Component.m_237119_());
        }
        tip = ExileTooltipUtils.removeBlankLines(tip, ExileTooltipUtils.RemoveOption.ONLY_DOUBLE_BLANK_LINES);
        return tip;
    }
}

