/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.library_of_exile.registry.serialization;

import com.google.gson.JsonObject;
import com.robertx22.library_of_exile.registry.IGUID;
import com.robertx22.library_of_exile.registry.IWeighted;

public interface ISerializable<T> {
    public static final String ID = "id";
    public static final String WEIGHT = "weight";

    public JsonObject toJson();

    public T fromJson(JsonObject var1);

    default public String datapackFolder() {
        return "";
    }

    default public String getGUIDFromJson(JsonObject json) {
        return json.get(ID).getAsString();
    }

    default public int getWeightFromJson(JsonObject json) {
        return json.get(WEIGHT).getAsInt();
    }

    default public JsonObject getDefaultJson() {
        Object claz;
        JsonObject json = new JsonObject();
        if (this instanceof IGUID) {
            claz = (IGUID)((Object)this);
            json.addProperty(ID, claz.GUID());
        }
        if (this instanceof IWeighted) {
            claz = (IWeighted)((Object)this);
            json.addProperty(WEIGHT, (Number)claz.Weight());
        }
        return json;
    }

    default public String toJsonString() {
        return this.toJson().toString();
    }

    default public boolean shouldGenerateJson() {
        return true;
    }
}

