/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.library_of_exile.registry.loaders;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.robertx22.library_of_exile.main.ExileLog;
import com.robertx22.library_of_exile.registry.Database;
import com.robertx22.library_of_exile.registry.ExileRegistry;
import com.robertx22.library_of_exile.registry.ExileRegistryContainer;
import com.robertx22.library_of_exile.registry.ExileRegistryType;
import com.robertx22.library_of_exile.registry.IAutoGson;
import com.robertx22.library_of_exile.registry.JsonExileRegistry;
import com.robertx22.library_of_exile.registry.register_info.FromDatapackRegistration;
import com.robertx22.library_of_exile.registry.serialization.ISerializable;
import com.robertx22.library_of_exile.utils.Watch;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;

public class BaseDataPackLoader<T extends ExileRegistry>
extends SimpleJsonResourceReloadListener {
    private static Gson GSON = IAutoGson.createGson();
    public String id;
    ISerializable<T> serializer;
    public ExileRegistryType registryType;
    public static HashMap<ExileRegistryType, List<String>> INFO_MAP = new HashMap();
    public static String ENABLED = "enabled";
    public static String LOADER = "loader";

    public BaseDataPackLoader(ExileRegistryType registryType, String id, ISerializable<T> serializer) {
        super(GSON, id);
        Objects.requireNonNull(registryType);
        this.id = id;
        this.serializer = serializer;
        this.registryType = registryType;
    }

    protected Map<ResourceLocation, JsonElement> m_5944_(ResourceManager manager, ProfilerFiller profiler) {
        return super.m_5944_(manager, profiler);
    }

    String getInfoString(ResourceLocation key, LoaderType type) {
        return key.m_135827_() + ":" + key.m_135815_() + ":" + type.name();
    }

    protected void apply(Map<ResourceLocation, JsonElement> mapToLoad, ResourceManager manager, ProfilerFiller profilerIn) {
        try {
            ExileRegistryContainer reg = Database.getRegistry(this.registryType);
            Watch normal = new Watch();
            normal.min = 50000;
            INFO_MAP.put(this.registryType, new ArrayList());
            for (Map.Entry<ResourceLocation, JsonElement> entry : mapToLoad.entrySet()) {
                ResourceLocation key = entry.getKey();
                JsonElement value = entry.getValue();
                try {
                    JsonObject json = null;
                    ExileRegistry object = null;
                    try {
                        json = value.getAsJsonObject();
                        object = (ExileRegistry)this.serializer.fromJson(json);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        String info = this.getInfoString(entry.getKey(), LoaderType.ERROR_LOADING);
                        INFO_MAP.get(this.registryType).add(info);
                        continue;
                    }
                    LoaderType type = LoaderType.REPLACE_FULLY;
                    if (json.has(LOADER)) {
                        try {
                            type = LoaderType.valueOf(json.get(LOADER).getAsString());
                        }
                        catch (IllegalArgumentException e) {
                            type = LoaderType.REPLACE_FULLY;
                        }
                    }
                    if (Database.getRegistry(this.registryType).isExistingSeriazable(object.GUID()) && type == LoaderType.REPLACE_FIELDS && Database.getRegistry(this.registryType).isExistingSeriazable(object.GUID())) {
                        Object existing = Database.getRegistry(this.registryType).get(object.GUID());
                        ISerializable exSer = (ISerializable)existing;
                        JsonObject existingJson = exSer.toJson();
                        for (Map.Entry en : json.entrySet()) {
                            existingJson.add((String)en.getKey(), (JsonElement)en.getValue());
                        }
                        object = (ExileRegistry)this.serializer.fromJson(existingJson);
                    }
                    if (!json.has(ENABLED) || json.get(ENABLED).getAsBoolean()) {
                        object.unregisterFromExileRegistry();
                        object.registerToExileRegistry(new FromDatapackRegistration(key));
                        String infostring = this.getInfoString(key, type);
                        INFO_MAP.get(this.registryType).add(infostring);
                    }
                    if (json.has(ENABLED) && !json.get(ENABLED).getAsBoolean()) {
                        object.unregisterFromExileRegistry();
                    }
                    if (object == null) continue;
                    JsonObject compare = json.deepCopy();
                    compare.remove(ENABLED);
                    object.compareLoadedJsonAndFinalClass(compare, type == LoaderType.REPLACE_FIELDS);
                }
                catch (Exception exception) {
                    ExileLog.get().warn(key.toString() + " is a broken datapack entry.", new Object[0]);
                    JsonExileRegistry.addToErroredJsons(this.registryType, key);
                    exception.printStackTrace();
                }
            }
            normal.print("Loading " + this.registryType.id + " jsons ");
            if (reg.isEmpty()) {
                throw new RuntimeException("Exile Registry of type " + this.registryType.id + " is EMPTY after datapack loading!");
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }

    public static enum LoaderType {
        REPLACE_FULLY,
        REPLACE_FIELDS,
        ERROR_LOADING;

    }
}

