/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.library_of_exile.registry;

import com.google.common.base.Preconditions;
import com.robertx22.library_of_exile.main.ExileLog;
import com.robertx22.library_of_exile.registry.Database;
import com.robertx22.library_of_exile.registry.ExileDatapackGenerator;
import com.robertx22.library_of_exile.registry.SyncTime;
import com.robertx22.library_of_exile.registry.loaders.BaseDataPackLoader;
import com.robertx22.library_of_exile.registry.serialization.ISerializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;

public class ExileRegistryType {
    private static HashMap<String, ExileRegistryType> map = new HashMap();
    public String id;
    ISerializable ser;
    int order;
    public SyncTime syncTime;
    public String modid;
    public String idWithoutModid;

    public ExileRegistryType(String modid, String id, int order, ISerializable ser, SyncTime synctime) {
        Preconditions.checkNotNull((Object)modid);
        Preconditions.checkNotNull((Object)id);
        Preconditions.checkNotNull((Object)order);
        Preconditions.checkNotNull((Object)((Object)synctime));
        this.modid = modid;
        this.idWithoutModid = id;
        this.id = modid + "_" + id;
        this.order = order;
        this.ser = ser;
        this.syncTime = synctime;
    }

    public String getModName() {
        return ((ModContainer)ModList.get().getModContainerById(this.modid).get()).getModInfo().getDisplayName();
    }

    public static ExileRegistryType get(String id) {
        return map.get(id);
    }

    public static ExileRegistryType register(ExileRegistryType type) {
        Preconditions.checkNotNull((Object)type);
        if (map.containsKey(type.id)) {
            ExileLog.get().warn("Duplicate ExileRegistryType: " + type.id, new Object[0]);
        }
        map.put(type.id, type);
        return type;
    }

    public static ExileRegistryType register(String modid, String id, int order, ISerializable ser, SyncTime synctime) {
        ExileRegistryType type = new ExileRegistryType(modid, id, order, ser, synctime);
        return ExileRegistryType.register(type);
    }

    public static List<ExileRegistryType> getInRegisterOrder(SyncTime sync) {
        List<ExileRegistryType> list = map.values().stream().filter(x -> x.syncTime == sync).collect(Collectors.toList());
        list.sort(Comparator.comparingInt(x -> x.order));
        return list;
    }

    public static List<ExileRegistryType> getAllInRegisterOrder() {
        ArrayList<ExileRegistryType> list = new ArrayList<ExileRegistryType>();
        for (Map.Entry<String, ExileRegistryType> en : map.entrySet()) {
            if (en.getValue() == null) {
                throw new RuntimeException(en.getKey() + " is a null registry type, how?!");
            }
            list.add(en.getValue());
        }
        list.sort(Comparator.comparingInt(x -> x.order));
        return list;
    }

    public static void registerJsonListeners(AddReloadListenerEvent manager) {
        List<ExileRegistryType> list = ExileRegistryType.getAllInRegisterOrder();
        list.forEach(x -> {
            if (x.getLoader() != null) {
                manager.addListener((PreparableReloadListener)x.getLoader());
            }
        });
    }

    public BaseDataPackLoader getLoader() {
        if (this.ser == null) {
            return null;
        }
        return new BaseDataPackLoader(this, this.id, this.ser);
    }

    public ExileDatapackGenerator getDatapackGenerator() {
        return new ExileDatapackGenerator(this.modid, this.getAllForSerialization(), this.id);
    }

    public List getAllForSerialization() {
        return Database.getRegistry(this).getSerializable();
    }

    public final ISerializable getSerializer() {
        return this.ser;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        return obj.hashCode() == this.hashCode();
    }
}

