/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.server.storage.world;

import com.hammy275.immersivemc.server.ServerUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.SharedConstants;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.saveddata.SavedData;

public class ImmersiveMCPlayerStorages
extends SavedData {
    private static final int PLAYER_STORAGES_VERSION = 2;
    protected Map<UUID, List<ItemStack>> backpackCraftingItemsMap = new HashMap<UUID, List<ItemStack>>();
    protected Set<UUID> disabledPlayers = new HashSet<UUID>();

    private static ImmersiveMCPlayerStorages create() {
        return new ImmersiveMCPlayerStorages();
    }

    public static List<ItemStack> getBackpackCraftingStorage(Player player) {
        return ImmersiveMCPlayerStorages.getPlayerStorage((Player)player).backpackCraftingItemsMap.computeIfAbsent(player.m_20148_(), uuid -> {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            for (int i = 0; i <= 4; ++i) {
                items.add(ItemStack.f_41583_);
            }
            return items;
        });
    }

    public static ImmersiveMCPlayerStorages getPlayerStorage(Player player) {
        if (!player.m_9236_().f_46443_) {
            ServerPlayer sPlayer = (ServerPlayer)player;
            return (ImmersiveMCPlayerStorages)sPlayer.m_20194_().m_129783_().m_8895_().m_164861_(ImmersiveMCPlayerStorages::load, ImmersiveMCPlayerStorages::create, "immersivemc_player_data");
        }
        throw new IllegalArgumentException("Can only access storage on server-side!");
    }

    public static boolean isPlayerDisabled(Player player) {
        return ImmersiveMCPlayerStorages.getPlayerStorage((Player)player).disabledPlayers.contains(player.m_20148_());
    }

    public static void setPlayerDisabled(Player player) {
        ImmersiveMCPlayerStorages storage = ImmersiveMCPlayerStorages.getPlayerStorage(player);
        storage.disabledPlayers.add(player.m_20148_());
        storage.m_77762_();
    }

    public static void setPlayerEnabled(Player player) {
        ImmersiveMCPlayerStorages storage = ImmersiveMCPlayerStorages.getPlayerStorage(player);
        storage.disabledPlayers.remove(player.m_20148_());
        storage.m_77762_();
    }

    public static ImmersiveMCPlayerStorages load(CompoundTag nbt) {
        CompoundTag disabledPlayers;
        ImmersiveMCPlayerStorages playerStorage = new ImmersiveMCPlayerStorages();
        int lastVanillaDataVersion = nbt.m_128441_("lastVanillaDataVersion") ? nbt.m_128451_("lastVanillaDataVersion") : Math.min(3700, SharedConstants.m_183709_().m_183476_().m_193006_());
        nbt = ImmersiveMCPlayerStorages.maybeUpgradeNBT(nbt, lastVanillaDataVersion);
        Set keys = nbt.m_128431_();
        for (String uuidStr : keys) {
            try {
                UUID uuid = UUID.fromString(uuidStr);
                CompoundTag bagItems = nbt.m_128469_(uuidStr).m_128469_("bagItems");
                ArrayList<ItemStack> items = new ArrayList<ItemStack>();
                for (int i = 0; i <= 4; ++i) {
                    items.add(ServerUtil.parseItem(bagItems.m_128469_(String.valueOf(i)), lastVanillaDataVersion));
                }
                playerStorage.backpackCraftingItemsMap.put(uuid, items);
            }
            catch (IllegalArgumentException uuid) {}
        }
        CompoundTag compoundTag = disabledPlayers = nbt.m_128441_("disabledPlayers") ? nbt.m_128469_("disabledPlayers") : null;
        if (disabledPlayers != null) {
            for (String key : disabledPlayers.m_128431_()) {
                if (!disabledPlayers.m_128461_(key).equalsIgnoreCase("true")) continue;
                playerStorage.disabledPlayers.add(UUID.fromString(key));
            }
        }
        return playerStorage;
    }

    public CompoundTag m_7176_(CompoundTag nbt) {
        nbt.m_128405_("lastVanillaDataVersion", SharedConstants.m_183709_().m_183476_().m_193006_());
        nbt.m_128405_("version", 2);
        for (Map.Entry<UUID, List<ItemStack>> entry : this.backpackCraftingItemsMap.entrySet()) {
            CompoundTag playerData = new CompoundTag();
            CompoundTag bagData = new CompoundTag();
            List<ItemStack> items = entry.getValue();
            for (int i = 0; i <= 4; ++i) {
                CompoundTag itemData = new CompoundTag();
                itemData = i >= items.size() ? ItemStack.f_41583_.m_41739_(itemData) : items.get(i).m_41739_(itemData);
                bagData.m_128365_(String.valueOf(i), (Tag)itemData);
            }
            playerData.m_128365_("bagItems", (Tag)bagData);
            nbt.m_128365_(String.valueOf(entry.getKey()), (Tag)playerData);
        }
        CompoundTag disabledPlayers = new CompoundTag();
        for (UUID disabled : this.disabledPlayers) {
            disabledPlayers.m_128359_(disabled.toString(), "true");
        }
        nbt.m_128365_("disabledPlayers", (Tag)disabledPlayers);
        return nbt;
    }

    private static CompoundTag maybeUpgradeNBT(CompoundTag nbtIn, int lastVanillaDataVersion) {
        int version = 1;
        if (nbtIn.m_128441_("version")) {
            version = nbtIn.m_128451_("version");
        }
        while (version < 2) {
            if (version == 1) {
                CompoundTag newNBT = new CompoundTag();
                Set keys = nbtIn.m_128431_();
                for (String uuidStr : keys) {
                    CompoundTag oldPlayerData = nbtIn.m_128469_(uuidStr);
                    CompoundTag bagItems = oldPlayerData.m_128469_("storages").m_128469_("0").m_128469_("data");
                    bagItems.m_128473_("identifier");
                    bagItems.m_128473_("numOfItems");
                    for (int i = 0; i <= 4; ++i) {
                        CompoundTag itemData = bagItems.m_128469_("item" + i);
                        bagItems.m_128473_("item" + i);
                        bagItems.m_128365_(String.valueOf(i), (Tag)itemData);
                    }
                    CompoundTag newPlayerData = new CompoundTag();
                    newPlayerData.m_128365_("bagItems", (Tag)bagItems);
                    newNBT.m_128365_(uuidStr, (Tag)newPlayerData);
                }
                nbtIn = newNBT;
            }
            ++version;
        }
        return nbtIn;
    }
}

