/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.server.immersive;

import com.hammy275.immersivemc.api.common.immersive.ImmersiveHandler;
import com.hammy275.immersivemc.common.immersive.handler.ImmersiveHandlers;
import com.hammy275.immersivemc.common.network.Network;
import com.hammy275.immersivemc.common.util.Util;
import com.hammy275.immersivemc.server.immersive.TrackedImmersiveData;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class TrackedImmersives {
    public static final List<TrackedImmersiveData<?>> TRACKED_IMMERSIVES = new ArrayList();

    public static void tick(MinecraftServer server) {
        Iterator<TrackedImmersiveData<?>> dataIterator = TRACKED_IMMERSIVES.iterator();
        while (dataIterator.hasNext()) {
            TrackedImmersiveData<?> data2 = dataIterator.next();
            ServerPlayer player = server.m_6846_().m_11259_(data2.playerUUID);
            if (player != null && data2.validForPlayer(player)) continue;
            if (player != null) {
                data2.getHandler().onStopTracking(player, data2.getPos().iterator().next());
            }
            dataIterator.remove();
        }
        TRACKED_IMMERSIVES.forEach(data -> {
            ServerPlayer player = server.m_6846_().m_11259_(data.playerUUID);
            if (data.shouldSync(player)) {
                TrackedImmersives.syncDataToClient(player, data);
            }
        });
    }

    public static void maybeTrackImmersive(ServerPlayer player, BlockPos pos) {
        for (ImmersiveHandler<?> handler : ImmersiveHandlers.HANDLERS) {
            if (handler.clientAuthoritative() || !handler.enabledInConfig((Player)player) || !Util.isValidBlocks(handler, pos, player.m_9236_())) continue;
            TrackedImmersives.trackImmersive(player, handler, pos);
            return;
        }
    }

    public static void clearForPlayer(ServerPlayer player) {
        Iterator<TrackedImmersiveData<?>> dataIterator = TRACKED_IMMERSIVES.iterator();
        while (dataIterator.hasNext()) {
            TrackedImmersiveData<?> data = dataIterator.next();
            if (!data.playerUUID.equals(player.m_20148_())) continue;
            data.getHandler().onStopTracking(player, data.getPos().iterator().next());
            dataIterator.remove();
        }
    }

    private static void trackImmersive(ServerPlayer player, ImmersiveHandler<?> handler, BlockPos pos) {
        if (TRACKED_IMMERSIVES.stream().anyMatch(data -> Util.getValidBlocks(data.getHandler(), data.getPos().iterator().next(), player.m_9236_()).contains(pos) && data.playerUUID.equals(player.m_20148_()))) {
            return;
        }
        TrackedImmersiveData data2 = new TrackedImmersiveData(player.m_20148_(), Util.getValidBlocks(handler, pos, player.m_9236_()), handler, player.m_9236_());
        TRACKED_IMMERSIVES.add(data2);
        TrackedImmersives.syncDataToClient(player, data2);
    }

    private static void syncDataToClient(ServerPlayer player, TrackedImmersiveData<?> data) {
        if (!data.getHandler().clientAuthoritative()) {
            Network.INSTANCE.sendToPlayer(player, data.getSyncPacket(player));
        }
    }
}

