/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.server;

import com.hammy275.immersivemc.api.common.immersive.ImmersiveHandler;
import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.immersive.CommonBookData;
import com.hammy275.immersivemc.common.immersive.handler.ImmersiveHandlers;
import com.hammy275.immersivemc.common.immersive.storage.network.impl.LecternData;
import com.hammy275.immersivemc.common.network.Network;
import com.hammy275.immersivemc.common.network.packet.ConfigSyncPacket;
import com.hammy275.immersivemc.common.tracker.AbstractTracker;
import com.hammy275.immersivemc.common.vr.VRPluginVerify;
import com.hammy275.immersivemc.server.ChestToOpenSet;
import com.hammy275.immersivemc.server.ServerVRSubscriber;
import com.hammy275.immersivemc.server.immersive.DirtyTracker;
import com.hammy275.immersivemc.server.immersive.TrackedImmersives;
import com.hammy275.immersivemc.server.storage.server.SharedNetworkStorages;
import com.hammy275.immersivemc.server.storage.world.ImmersiveMCLevelStorage;
import com.hammy275.immersivemc.server.storage.world.ImmersiveMCPlayerStorages;
import com.hammy275.immersivemc.server.tracker.ServerTrackerInit;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class ServerSubscriber {
    public static MinecraftServer server;

    public static void onServerTick(MinecraftServer server) {
        ServerSubscriber.server = server;
        SharedNetworkStorages.instance().getAll(LecternData.class).forEach(data -> data.tick(null));
        for (AbstractTracker tracker : ServerTrackerInit.globalTrackers) {
            tracker.doTick(null);
        }
        TrackedImmersives.tick(server);
        DirtyTracker.unmarkAllDirty();
        ImmersiveMCLevelStorage.unmarkAllItemStoragesDirty(server);
        SharedNetworkStorages.instance().getAll(LecternData.class).forEach(data -> ((CommonBookData)data.bookData).setNoLongerDirty());
    }

    public static void onPlayerTick(Player playerIn) {
        BlockHitResult blockHit;
        HitResult hit;
        if (playerIn.m_9236_().f_46443_) {
            return;
        }
        ServerPlayer player = (ServerPlayer)playerIn;
        for (AbstractTracker tracker : ServerTrackerInit.playerTrackers) {
            tracker.doTick((Player)player);
        }
        if (VRPluginVerify.hasAPI) {
            ServerVRSubscriber.vrPlayerTick(player);
        }
        if ((hit = player.m_19907_(15.0, 0.0f, false)) instanceof BlockHitResult && (blockHit = (BlockHitResult)hit).m_6662_() != HitResult.Type.MISS) {
            TrackedImmersives.maybeTrackImmersive(player, blockHit.m_82425_());
        }
    }

    public static void onPlayerJoin(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ActiveConfig config = ImmersiveMCPlayerStorages.isPlayerDisabled((Player)serverPlayer) ? ActiveConfig.DISABLED : ActiveConfig.FILE_SERVER;
            Network.INSTANCE.sendToPlayer(serverPlayer, new ConfigSyncPacket(config, ImmersiveHandlers.HANDLERS.stream().filter(handler -> !handler.clientAuthoritative()).map(ImmersiveHandler::getID).toList()));
        }
    }

    public static void onPlayerLeave(Player playerIn) {
        if (playerIn instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)playerIn;
            TrackedImmersives.clearForPlayer(player);
            ChestToOpenSet.clearForPlayer((Player)player);
        }
    }
}

