/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.forge;

import com.hammy275.immersivemc.forge.BufferPacket;
import com.hammy275.immersivemc.forge.ImmersiveMCForge;
import com.mojang.brigadier.CommandDispatcher;
import java.io.File;
import java.util.function.Consumer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.network.PacketDistributor;

public class PlatformImpl {
    public static boolean isClient() {
        return FMLEnvironment.dist == Dist.CLIENT;
    }

    public static boolean isDevelopmentEnvironment() {
        return !FMLEnvironment.production;
    }

    public static boolean isForgeLike() {
        return true;
    }

    public static boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    public static File getConfigFolder() {
        return FMLPaths.CONFIGDIR.get().toFile();
    }

    public static void registerServerPostTickListener(Consumer<MinecraftServer> listener) {
        MinecraftForge.EVENT_BUS.addListener(event -> {
            if (event.phase == TickEvent.Phase.END) {
                listener.accept(event.getServer());
            }
        });
    }

    public static void registerServerPlayerPostTickListener(Consumer<ServerPlayer> listener) {
        MinecraftForge.EVENT_BUS.addListener(event -> {
            if (event.phase == TickEvent.Phase.END) {
                event.getServer().m_6846_().m_11314_().forEach(listener);
            }
        });
    }

    public static void registerServerPlayerJoinListener(Consumer<ServerPlayer> listener) {
        MinecraftForge.EVENT_BUS.addListener(event -> {
            Player patt2297$temp = event.getEntity();
            if (patt2297$temp instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)patt2297$temp;
                listener.accept(sp);
            }
        });
    }

    public static void registerServerPlayerLeaveListener(Consumer<ServerPlayer> listener) {
        MinecraftForge.EVENT_BUS.addListener(event -> {
            Player patt2613$temp = event.getEntity();
            if (patt2613$temp instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)patt2613$temp;
                listener.accept(sp);
            }
        });
    }

    public static void registerCommands(Consumer<CommandDispatcher<CommandSourceStack>> listener) {
        MinecraftForge.EVENT_BUS.addListener(event -> listener.accept(event.getDispatcher()));
    }

    public static void sendToServer(FriendlyByteBuf message) {
        ImmersiveMCForge.NETWORK.sendToServer((Object)new BufferPacket(message));
    }

    public static void sendToPlayer(ServerPlayer player, FriendlyByteBuf message) {
        ImmersiveMCForge.NETWORK.send(PacketDistributor.PLAYER.with(() -> player), (Object)new BufferPacket(message));
    }

    public static Fluid getFluid(BucketItem bucket) {
        return bucket.getFluid();
    }
}

