/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.common.vr;

import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.network.Network;
import com.hammy275.immersivemc.common.network.packet.DoubleControllerVibrate;
import com.hammy275.immersivemc.common.vr.VRPlugin;
import com.hammy275.immersivemc.common.vr.VRPluginVerify;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class VRRumble {
    private static boolean rumbleInVRConfigCheck(Player player) {
        if (player instanceof ServerPlayer) {
            return ActiveConfig.getConfigForPlayer((Player)player).doVRControllerRumble;
        }
        return ActiveConfig.FILE_CLIENT.doVRControllerRumble;
    }

    public static void rumbleIfVR(Player player, int controller, float rumbleDuration) {
        if (VRPluginVerify.hasAPI && VRPlugin.API.playerInVR(player) && VRRumble.rumbleInVRConfigCheck(player)) {
            ServerPlayer sp;
            VRPlugin.API.triggerHapticPulse(controller, rumbleDuration, player instanceof ServerPlayer ? (sp = (ServerPlayer)player) : null);
        }
    }

    public static void doubleRumbleIfVR(Player player, float rumbleDuration) {
        if (VRPluginVerify.hasAPI && VRPlugin.API.playerInVR(player)) {
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                Network.INSTANCE.sendToPlayer(sp, new DoubleControllerVibrate(rumbleDuration));
            } else {
                VRRumble.rumbleIfVR(player, 0, rumbleDuration);
                VRRumble.rumbleIfVR(player, 1, rumbleDuration);
            }
        }
    }
}

