/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.common.util;

import com.hammy275.immersivemc.api.client.immersive.Immersive;
import com.hammy275.immersivemc.api.client.immersive.ImmersiveInfo;
import com.hammy275.immersivemc.api.common.ImmersiveLogicHelpers;
import com.hammy275.immersivemc.api.common.hitbox.BoundingBox;
import com.hammy275.immersivemc.api.common.hitbox.HitboxInfo;
import com.hammy275.immersivemc.api.common.immersive.ImmersiveHandler;
import com.hammy275.immersivemc.api.common.immersive.MultiblockImmersiveHandler;
import com.hammy275.immersivemc.api.common.immersive.NetworkStorage;
import com.hammy275.immersivemc.client.immersive.Immersives;
import com.hammy275.immersivemc.common.immersive.ImmersiveChecker;
import com.hammy275.immersivemc.common.immersive.ImmersiveCheckers;
import com.hammy275.immersivemc.common.immersive.handler.ImmersiveHandlers;
import com.hammy275.immersivemc.server.immersive.TrackedImmersives;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.RepeaterBlock;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class Util {
    public static UseInfo activeUseInfo = null;

    public static boolean blockIsActiveImmersive(Player player, BlockPos pos) {
        Level level = player.m_9236_();
        if (level.f_46443_) {
            for (Immersive<? extends ImmersiveInfo, ? extends NetworkStorage> singleton : Immersives.IMMERSIVES) {
                ImmersiveHandler<? extends NetworkStorage> immersiveHandler = singleton.getHandler();
                if (immersiveHandler instanceof MultiblockImmersiveHandler) {
                    MultiblockImmersiveHandler handler = (MultiblockImmersiveHandler)immersiveHandler;
                    for (ImmersiveInfo immersiveInfo : singleton.getTrackedObjects()) {
                        Set<BlockPos> handledBlocks = handler.getHandledBlocks(pos, level);
                        if (handledBlocks == null || !handledBlocks.contains(immersiveInfo.getBlockPosition())) continue;
                        return true;
                    }
                    continue;
                }
                for (ImmersiveInfo immersiveInfo : singleton.getTrackedObjects()) {
                    if (!immersiveInfo.getBlockPosition().equals((Object)pos)) continue;
                    return true;
                }
            }
            return false;
        }
        return TrackedImmersives.TRACKED_IMMERSIVES.stream().anyMatch(data -> data.playerUUID.equals(player.m_20148_()) && data.getPos().contains(pos));
    }

    public static InteractionHand otherHand(InteractionHand hand) {
        return hand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InteractionResultHolder<ItemStack> doUse(Player player, InteractionHand hand, BlockPos pos) {
        InteractionResultHolder result;
        try {
            activeUseInfo = new UseInfo(player, hand, pos);
            result = player.m_21120_(hand).m_41682_(player.m_9236_(), player, hand);
        }
        finally {
            activeUseInfo = null;
        }
        return result;
    }

    public static Vec3 getLookAngle(float pitch, float yaw) {
        float yawCos = Mth.m_14089_((float)pitch);
        return new Vec3((double)(Mth.m_14031_((float)yaw) * yawCos), (double)(-Mth.m_14031_((float)pitch)), (double)(Mth.m_14089_((float)yaw) * yawCos));
    }

    public static boolean isValidBlocks(ImmersiveHandler<?> handler, BlockPos pos, Level level) {
        return Util.getValidBlocks(handler, pos, level).contains(pos);
    }

    public static boolean isValidBlocks(ImmersiveHandler<?> handler, Set<BlockPos> pos, Level level) {
        return Util.getValidBlocks(handler, pos.iterator().next(), level).equals(pos);
    }

    public static Set<BlockPos> getValidBlocks(ImmersiveHandler<?> handler, BlockPos pos, Level level) {
        boolean valid = handler.isValidBlock(pos, level);
        if (valid) {
            if (handler instanceof MultiblockImmersiveHandler) {
                MultiblockImmersiveHandler mih = (MultiblockImmersiveHandler)handler;
                Set<BlockPos> positions = mih.getHandledBlocks(pos, level);
                if (positions != null && positions.stream().allMatch(p -> handler.isValidBlock((BlockPos)p, level))) {
                    return positions;
                }
                return Set.of();
            }
            return Set.of(pos);
        }
        return Set.of();
    }

    public static Vec3 average(Set<BlockPos> positions) {
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        for (BlockPos pos : positions) {
            x += (double)pos.m_123341_();
            y += (double)pos.m_123342_();
            z += (double)pos.m_123343_();
        }
        return new Vec3(x / (double)positions.size(), y / (double)positions.size(), z / (double)positions.size());
    }

    public static boolean isThrowableItem(Item item) {
        return item == Items.f_42612_ || item == Items.f_42521_ || item == Items.f_42584_ || item == Items.f_42736_ || item == Items.f_42739_ || item == Items.f_42452_ || item instanceof TridentItem || item instanceof FishingRodItem;
    }

    public static Direction horizontalDirectionFromLook(Vec3 look) {
        double maxLook = Math.max(Math.abs(look.f_82479_), Math.abs(look.f_82481_));
        if (maxLook == Math.abs(look.f_82479_)) {
            return look.f_82479_ < 0.0 ? Direction.WEST : Direction.EAST;
        }
        return look.f_82481_ < 0.0 ? Direction.NORTH : Direction.SOUTH;
    }

    public static boolean isHittingImmersive(BlockHitResult result, Level level) {
        BlockPos pos = result.m_82425_();
        for (ImmersiveChecker checker : ImmersiveCheckers.CHECKERS) {
            if (!checker.apply(pos, level)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasItemInInventoryWithStackSpace(Player player, ItemStack stack) {
        for (ItemStack invItem : player.m_150109_().f_35974_) {
            if (!Util.stacksEqualBesidesCount(invItem, stack) || invItem.m_41613_() >= invItem.m_41741_()) continue;
            return true;
        }
        return false;
    }

    public static boolean canPickUpItem(ItemEntity item, Player player) {
        return (!item.m_32063_() || player.m_150110_().f_35937_) && Math.abs(item.m_20184_().f_82479_) <= 0.01 && Math.abs(item.m_20184_().f_82481_) <= 0.01;
    }

    public static Optional<Integer> rayTraceClosest(Pair<Vec3, Vec3> rayStartAndEnd, BoundingBox ... targets) {
        return Util.rayTraceClosest((Vec3)rayStartAndEnd.getFirst(), (Vec3)rayStartAndEnd.getSecond(), targets);
    }

    public static Optional<Integer> rayTraceClosest(Vec3 rayStart, Vec3 rayEnd, BoundingBox ... targets) {
        return Util.rayTraceClosest(rayStart, rayEnd, Arrays.stream(targets).toList());
    }

    public static Optional<Integer> rayTraceClosest(Vec3 rayStart, Vec3 rayEnd, Collection<? extends HitboxInfo> targets) {
        return Util.rayTraceClosest(rayStart, rayEnd, targets.stream().map(info -> info != null ? info.getHitbox() : null).toList());
    }

    public static Optional<Integer> rayTraceClosest(Vec3 rayStart, Vec3 rayEnd, Iterable<BoundingBox> targets) {
        double dist = Double.MAX_VALUE;
        Integer winner = null;
        int i = 0;
        for (BoundingBox target : targets) {
            if (target != null) {
                double distTemp;
                if (BoundingBox.contains(target, rayStart)) {
                    return Optional.of(i);
                }
                Optional<Vec3> closestHitOpt = target.isAABB() ? target.asAABB().m_82371_(rayStart, rayEnd) : target.asOBB().rayHit(rayStart, rayEnd);
                double d = distTemp = closestHitOpt.isPresent() ? closestHitOpt.get().m_82557_(rayStart) : -1.0;
                if (closestHitOpt.isPresent() && distTemp < dist) {
                    winner = i;
                    dist = distTemp;
                }
            }
            ++i;
        }
        return Optional.ofNullable(winner);
    }

    public static Optional<Integer> getFirstIntersect(Vec3 pos, BoundingBox ... targets) {
        return Util.getFirstIntersect(pos, Arrays.stream(targets).toList());
    }

    public static Optional<Integer> getFirstIntersect(Vec3 pos, Collection<? extends HitboxInfo> targets) {
        return Util.getFirstIntersect(pos, targets.stream().map(info -> info != null ? info.getHitbox() : null).toList());
    }

    public static Optional<Integer> getFirstIntersect(Vec3 pos, Iterable<BoundingBox> targets) {
        int i = 0;
        for (BoundingBox target : targets) {
            if (target != null && BoundingBox.contains(target, pos)) {
                return Optional.of(i);
            }
            ++i;
        }
        return Optional.empty();
    }

    public static Optional<Integer> getClosestIntersect(Vec3 pos, List<BoundingBox> targets) {
        int res = -1;
        double distanceToBeat = Double.MAX_VALUE;
        for (int i = 0; i < targets.size(); ++i) {
            double newDist;
            if (targets.get(i) == null || !BoundingBox.contains(targets.get(i), pos) || !((newDist = pos.m_82557_(BoundingBox.getCenter(targets.get(i)))) < distanceToBeat)) continue;
            distanceToBeat = newDist;
            res = i;
        }
        return res == -1 ? Optional.empty() : Optional.of(res);
    }

    public static ChestBlockEntity getOtherChest(ChestBlockEntity chest) {
        return Util.getOtherChest(chest, true);
    }

    protected static ChestBlockEntity getOtherChest(ChestBlockEntity chest, boolean checkOther) {
        if (chest == null) {
            return null;
        }
        Direction otherDir = ChestBlock.m_51584_((BlockState)chest.m_58900_());
        BlockPos otherPos = chest.m_58899_().m_121945_(otherDir);
        if (chest.m_58904_() != null && chest.m_58904_().m_7702_(otherPos) instanceof ChestBlockEntity) {
            ChestBlockEntity other = (ChestBlockEntity)chest.m_58904_().m_7702_(otherPos);
            if (checkOther && other != null) {
                return Util.getOtherChest(other, false) == chest ? other : null;
            }
            return other;
        }
        return null;
    }

    public static boolean stacksEqualBesidesCount(ItemStack a, ItemStack b) {
        if (a.m_41619_() && b.m_41619_()) {
            return true;
        }
        if (a.m_41619_() || b.m_41619_()) {
            return false;
        }
        int oldCountA = a.m_41613_();
        int oldCountB = b.m_41613_();
        a.m_41764_(1);
        b.m_41764_(1);
        boolean res = ItemStack.m_41728_((ItemStack)a, (ItemStack)b);
        a.m_41764_(oldCountA);
        b.m_41764_(oldCountB);
        return res;
    }

    public static ItemStackMergeResult mergeStacks(ItemStack mergeIntoIn, ItemStack mergeFromIn, boolean useCopy) {
        return Util.mergeStacks(mergeIntoIn, mergeFromIn, useCopy, -1);
    }

    public static ItemStackMergeResult mergeStacks(ItemStack mergeIntoIn, ItemStack mergeFromIn, boolean useCopy, int forcedMaxMergeIntoSize) {
        int mergeIntoMaxStackSize;
        int n = mergeIntoMaxStackSize = forcedMaxMergeIntoSize == -1 ? mergeIntoIn.m_41741_() : forcedMaxMergeIntoSize;
        if (!Util.stacksEqualBesidesCount(mergeIntoIn, mergeFromIn) || mergeIntoMaxStackSize <= 1) {
            return new ItemStackMergeResult(mergeIntoIn, mergeFromIn);
        }
        ItemStack into = useCopy ? mergeIntoIn.m_41777_() : mergeIntoIn;
        ItemStack from = useCopy ? mergeFromIn.m_41777_() : mergeFromIn;
        int totalCount = into.m_41613_() + from.m_41613_();
        int fromAmount = 0;
        if (totalCount > mergeIntoMaxStackSize) {
            fromAmount = totalCount - mergeIntoMaxStackSize;
            totalCount = mergeIntoMaxStackSize;
        }
        into.m_41764_(totalCount);
        from.m_41764_(fromAmount);
        return new ItemStackMergeResult(into, fromAmount == 0 ? ItemStack.f_41583_ : from);
    }

    public static void setRepeater(Level level, BlockPos pos, int newDelay) {
        BlockState state = level.m_8055_(pos);
        if (state.m_60734_() instanceof RepeaterBlock) {
            state = (BlockState)state.m_61124_((Property)RepeaterBlock.f_55798_, (Comparable)Integer.valueOf(newDelay));
            level.m_7731_(pos, state, 3);
        }
    }

    public static void useLever(Player player, BlockPos pos) {
        if (ImmersiveCheckers.isLever(pos, player.m_9236_())) {
            BlockState lever = player.m_9236_().m_8055_(pos);
            lever.m_60664_(player.m_9236_(), player, InteractionHand.MAIN_HAND, new BlockHitResult(Vec3.m_82512_((Vec3i)pos), Direction.NORTH, pos, true));
        }
    }

    public static void useTrapdoor(Player player, Level level, BlockPos pos) {
        if (ImmersiveHandlers.trapdoorHandler.isValidBlock(pos, level)) {
            BlockState trapdoor = level.m_8055_(pos);
            trapdoor.m_60664_(level, player, InteractionHand.MAIN_HAND, new BlockHitResult(Vec3.m_82512_((Vec3i)pos), Direction.NORTH, pos, true));
        }
    }

    public static void useDoor(Player player, Level level, BlockPos pos) {
        if (ImmersiveHandlers.doorHandler.isValidBlock(pos, level)) {
            BlockState door = level.m_8055_(pos);
            door.m_60664_(level, player, InteractionHand.MAIN_HAND, new BlockHitResult(Vec3.m_82512_((Vec3i)pos), Direction.NORTH, pos, true));
        }
    }

    public static Vec3 getPlayerVelocity(Vec3 lastTickPos, Vec3 currentTickPos) {
        return new Vec3(currentTickPos.f_82479_ - lastTickPos.f_82479_, currentTickPos.f_82480_ - lastTickPos.f_82480_, currentTickPos.f_82481_ - lastTickPos.f_82481_);
    }

    public static double moveTowardsZero(double num, double subtract) {
        if ((subtract = Math.abs(subtract)) >= Math.abs(num)) {
            return 0.0;
        }
        if (num < 0.0) {
            return num + subtract;
        }
        return num - subtract;
    }

    public static void giveStackHandFirst(Player player, InteractionHand hand, ItemStack stack) {
        if (player.m_21120_(hand).m_41619_()) {
            player.m_21008_(hand, stack);
        } else {
            Util.placeLeftovers(player, stack);
        }
    }

    public static void placeLeftovers(Player player, ItemStack leftovers) {
        Util.placeLeftovers(player, leftovers, player.m_20182_());
    }

    public static void placeLeftovers(Player player, ItemStack leftovers, Vec3 pos) {
        if (!leftovers.m_41619_()) {
            ItemEntity item = new ItemEntity(player.m_9236_(), pos.f_82479_, pos.f_82480_, pos.f_82481_, leftovers);
            player.m_9236_().m_7967_((Entity)item);
        }
    }

    public static void putResourceLocation(CompoundTag nbt, String key, ResourceLocation loc) {
        CompoundTag locTag = new CompoundTag();
        locTag.m_128359_("namespace", loc.m_135827_());
        locTag.m_128359_("path", loc.m_135815_());
        nbt.m_128365_(key, (Tag)locTag);
    }

    public static ResourceLocation getResourceLocation(CompoundTag nbt, String key) {
        CompoundTag subTag = nbt.m_128469_(key);
        return new ResourceLocation(subTag.m_128461_("namespace"), subTag.m_128461_("path"));
    }

    public static List<BlockPos> allPositionsWithAABB(AABB box) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        int minX = (int)Math.floor(box.f_82288_);
        int minY = (int)Math.floor(box.f_82289_);
        int minZ = (int)Math.floor(box.f_82290_);
        int maxX = (int)Math.floor(box.f_82291_);
        int maxY = (int)Math.floor(box.f_82292_);
        int maxZ = (int)Math.floor(box.f_82293_);
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    positions.add(new BlockPos(x, y, z));
                }
            }
        }
        return positions;
    }

    public static Vec3[] get3x3HorizontalGrid(BlockPos blockPos, double spacing, Direction blockForward, boolean use3DCompat) {
        Vec3 pos = Vec3.m_82514_((Vec3i)blockPos, (double)1.0);
        if (use3DCompat) {
            pos = pos.m_82520_(0.0, 0.0625, 0.0);
        }
        Direction left = blockForward.m_122428_();
        Vec3 leftOffset = new Vec3((double)left.m_122436_().m_123341_() * -spacing, 0.0, (double)left.m_122436_().m_123343_() * -spacing);
        Vec3 rightOffset = new Vec3((double)left.m_122436_().m_123341_() * spacing, 0.0, (double)left.m_122436_().m_123343_() * spacing);
        Vec3 topOffset = new Vec3((double)blockForward.m_122436_().m_123341_() * -spacing, 0.0, (double)blockForward.m_122436_().m_123343_() * -spacing);
        Vec3 botOffset = new Vec3((double)blockForward.m_122436_().m_123341_() * spacing, 0.0, (double)blockForward.m_122436_().m_123343_() * spacing);
        return new Vec3[]{pos.m_82549_(leftOffset).m_82549_(topOffset), pos.m_82549_(topOffset), pos.m_82549_(rightOffset).m_82549_(topOffset), pos.m_82549_(leftOffset), pos, pos.m_82549_(rightOffset), pos.m_82549_(leftOffset).m_82549_(botOffset), pos.m_82549_(botOffset), pos.m_82549_(rightOffset).m_82549_(botOffset)};
    }

    public static Direction getForwardFromPlayerUpAndDown(Player player, BlockPos pos) {
        return Util.getForwardFromPlayerUpAndDownFilterBlockFacing(player, pos, false);
    }

    public static Direction getForwardFromPlayerUpAndDownFilterBlockFacing(Player player, BlockPos pos, boolean filterOnBlockFacing) {
        Direction.Axis filter = filterOnBlockFacing ? ((Direction)player.m_9236_().m_8055_(pos).m_61143_((Property)DirectionalBlock.f_52588_)).m_122434_() : null;
        Vec3 playerPos = player.m_20182_();
        if (playerPos.f_82480_ >= (double)pos.m_123342_() + 0.625 && filter != Direction.Axis.Y) {
            return Direction.UP;
        }
        if (playerPos.f_82480_ <= (double)pos.m_123342_() - 0.625 && filter != Direction.Axis.Y) {
            return Direction.DOWN;
        }
        Direction forward = ImmersiveLogicHelpers.instance().getHorizontalBlockForward(player, pos);
        if (forward.m_122434_() != filter) {
            return forward;
        }
        Direction blockFacing = (Direction)player.m_9236_().m_8055_(pos).m_61143_((Property)DirectionalBlock.f_52588_);
        Vec3 blockCenter = Vec3.m_82512_((Vec3i)pos);
        Direction blockLeftDir = blockFacing.m_122428_();
        Vec3 blockLeftVec = new Vec3((double)blockLeftDir.m_122436_().m_123341_(), (double)blockLeftDir.m_122436_().m_123342_(), (double)blockLeftDir.m_122436_().m_123343_());
        Vec3 counterClockwisePos = blockCenter.m_82549_(blockLeftVec.m_82490_(0.5));
        Vec3 clockwisePos = blockCenter.m_82549_(blockLeftVec.m_82490_(-0.5));
        Vec3 upPos = blockCenter.m_82520_(0.0, 0.5, 0.0);
        Vec3 downPos = blockCenter.m_82520_(0.0, -0.5, 0.0);
        double counterClockwiseDist = counterClockwisePos.m_82557_(playerPos);
        double clockwiseDist = clockwisePos.m_82557_(playerPos);
        double upDist = upPos.m_82557_(playerPos);
        double downDist = downPos.m_82557_(playerPos);
        double min = Math.min(counterClockwiseDist, clockwiseDist);
        min = Math.min(min, upDist);
        if ((min = Math.min(min, downDist)) == counterClockwiseDist) {
            return forward.m_122428_();
        }
        if (min == clockwiseDist) {
            return forward.m_122427_();
        }
        if (min == upDist) {
            return Direction.UP;
        }
        return Direction.DOWN;
    }

    public record UseInfo(Player player, InteractionHand hand, BlockPos pos) {
        public Vec3 getVec3Pos() {
            return Vec3.m_82512_((Vec3i)this.pos);
        }
    }

    public static class ItemStackMergeResult {
        public final ItemStack mergedInto;
        public final ItemStack mergedFrom;

        public ItemStackMergeResult(ItemStack mergedInto, ItemStack mergedFrom) {
            this.mergedInto = mergedInto;
            this.mergedFrom = mergedFrom;
        }

        public String toString() {
            return "Merged Into: " + this.mergedInto + "\nMerged From: " + this.mergedFrom;
        }
    }
}

