/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.common.tracker;

import com.hammy275.immersivemc.Platform;
import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.tracker.AbstractTracker;
import com.hammy275.immersivemc.common.util.Util;
import com.hammy275.immersivemc.common.vr.VRPlugin;
import com.hammy275.immersivemc.common.vr.VRPluginVerify;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.blf02.vrapi.api.data.IVRPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;

public class BottleAndBucketTracker
extends AbstractTracker {
    private final Map<UUID, Integer> cooldown = new HashMap<UUID, Integer>();

    @Override
    protected void tick(Player player) {
        for (int c = 0; c <= 1; ++c) {
            boolean isWaterSource;
            BucketPickup bp;
            IVRPlayer currentVRData;
            InteractionHand hand = InteractionHand.values()[c];
            ItemStack stackInHand = player.m_21120_(hand);
            if (!this.stackMatches(stackInHand) || !(Math.abs((currentVRData = VRPlugin.API.getVRPlayer(player)).getController(hand.ordinal()).getRoll()) < 90.0f)) continue;
            boolean holdingGlassBottle = stackInHand.m_150930_(Items.f_42590_);
            BlockPos pos = BlockPos.m_274446_((Position)currentVRData.getController(hand.ordinal()).position());
            BlockState state = player.m_9236_().m_8055_(pos);
            Block block = state.m_60734_();
            BucketPickup pickup = block instanceof BucketPickup ? (bp = (BucketPickup)block) : null;
            boolean bl = isWaterSource = state.m_60713_(Blocks.f_49990_) && (Integer)state.m_61143_((Property)BlockStateProperties.f_61422_) == 0;
            if ((!holdingGlassBottle || !isWaterSource) && pickup == null) continue;
            this.possiblyPlaceItemAndSetCooldown(player, hand, Util.doUse(player, hand, pos));
        }
    }

    @Override
    protected boolean shouldTick(Player player) {
        if (!VRPluginVerify.playerInVR(player)) {
            return false;
        }
        if (!ActiveConfig.getActiveConfigCommon((Player)player).useBucketAndBottleImmersive) {
            return false;
        }
        int newCooldown = this.cooldown.getOrDefault(player.m_20148_(), 0) - 1;
        if (newCooldown > 0) {
            this.cooldown.put(player.m_20148_(), newCooldown);
            return false;
        }
        this.cooldown.remove(player.m_20148_());
        return true;
    }

    private boolean stackMatches(ItemStack stackInHand) {
        BucketItem bucketItem;
        Item item;
        return stackInHand.m_150930_(Items.f_42590_) || (item = stackInHand.m_41720_()) instanceof BucketItem && Platform.getFluid(bucketItem = (BucketItem)item).m_6212_(Fluids.f_76191_);
    }

    private void possiblyPlaceItemAndSetCooldown(Player player, InteractionHand hand, InteractionResultHolder<ItemStack> res) {
        if (res.m_19089_().m_19077_() && !((ItemStack)res.m_19095_()).m_41619_()) {
            this.cooldown.put(player.m_20148_(), 5);
            player.m_21008_(hand, (ItemStack)res.m_19095_());
        }
    }
}

