/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.common.obb;

import com.hammy275.immersivemc.common.obb.OBBRot;
import com.hammy275.immersivemc.common.obb.RotType;
import java.util.ArrayList;
import java.util.List;
import org.joml.Quaternionf;

public class OBBRotList {
    private final List<OBBRot> rotList = new ArrayList<OBBRot>();

    private OBBRotList() {
    }

    private OBBRotList(OBBRot ... rotations) {
        for (OBBRot rot : rotations) {
            if (rot == null) {
                throw new NullPointerException("Cannot add null rotation to rotation list.");
            }
            if (rot.rot() == 0.0f) continue;
            this.rotList.add(rot);
        }
    }

    private OBBRotList(List<OBBRot> rotList) {
        this.rotList.addAll(rotList);
    }

    public OBBRotList addRot(float rot, RotType rotType) {
        if (rot != 0.0f) {
            this.rotList.add(new OBBRot(rot, rotType));
        }
        return this;
    }

    public OBBRotList addRot(double rot, RotType rotType) {
        return this.addRot((float)rot, rotType);
    }

    public List<OBBRot> getRotations() {
        return new ArrayList<OBBRot>(this.rotList);
    }

    public Quaternionf asQuaternion() {
        Quaternionf quaternion = new Quaternionf();
        for (OBBRot rot : this.rotList) {
            switch (rot.rotType()) {
                case PITCH: {
                    quaternion.rotateX(-rot.rot());
                    break;
                }
                case YAW: {
                    quaternion.rotateY(-rot.rot());
                    break;
                }
                case ROLL: {
                    quaternion.rotateZ(rot.rot());
                }
            }
        }
        return quaternion;
    }

    public OBBRotList copy() {
        return new OBBRotList(this.rotList);
    }

    public static OBBRotList create() {
        return new OBBRotList();
    }

    public static OBBRotList create(OBBRot ... rotations) {
        return new OBBRotList(rotations);
    }
}

